/**************************************************************
    CAN OPEN SAMPLE    - MBED MASTER
**************************************************************/
/*
This file is part of CanFestival, a library implementing CanOpen Stack.

Copyright (C): Edouard TISSERANT and Francis DUPIN
mbed Port: sgrove

See COPYING file for copyrights details.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/******************************************************************************
Project description:
    
    Allow a user to change the bus state by sending COM messages to the device
    57600 baud 8-n-1 send "help" for a list of options and formating info
    CAN speed - 125k

******************************************************************************/

#include "mbed.h"
#include "main.h"
#include "canfestival.h"
#include "can_mbed.h"
#include "mbed_master.h"
#include "port_helper.h"

// Set used for main program timing control
Ticker SysTimer;
// flag used by the main program timing control interrupt
uint8_t timer_interrupt = 0;

// CAN - put and take data from the stack
uint8_t nodeID;
uint8_t change_node_id;
NMTStateAdjustment stack_state = reset;

// read a can message from the stack
static Message m = Message_Initializer;
const Message empty_msg = Message_Initializer;

int main() 
{
    // start the debug helper
    initHelper();
    // start the system timer 
    SysTimer.attach_us(&serviceSysTimer, CYCLE_TIME*10);
    // Initialize the CANopen bus
    canInit(CAN_BAUDRATE);
    // Start timer for the CANopen stack
    initTimer();  
    // set the default node id (1-127)
    nodeID = 0x7f;
    // Init the state
    setState(&mbed_master_Data, Initialisation);
    setNodeId (&mbed_master_Data, nodeID);
    // Put the master in operational mode
    setState(&mbed_master_Data, Operational);

    // keep on loopin'
    while(1){
        
        // just testing the rx functionality
        if (canReceive(&m)){
            // the stack can crash with interrupts enabled
            __disable_irq();
            // pass the message on and process it
            canDispatch(&mbed_master_Data, &m); 
            // get back to work
            __enable_irq();
            // and print the message for debugging
            printMsg(m);
            // empty it for the next use
            m = empty_msg;
        }

        // set the main loop exectuion speed at 10mS
        if (sys_timer){
            // Reset timer
            reset_sys_timer();    

            // look for COM requests
            serviceCOMCommands();

            // change operational state??
            switch(stack_state){

                case start:
                    masterSendNMTstateChange (&mbed_master_Data, 0x00, NMT_Start_Node);
                    startSYNC(&mbed_master_Data);
                    stack_state = undefined;
                    break;

                case reset:
                    masterSendNMTstateChange (&mbed_master_Data, 0x00, NMT_Reset_Node);
                    startSYNC(&mbed_master_Data);
                    stack_state = undefined;
                    break;

                case stop:
                    masterSendNMTstateChange (&mbed_master_Data, 0x00, NMT_Stop_Node );
                    stopSYNC(&mbed_master_Data);
                    stack_state = undefined;
                    break;
                
                default:
                    break;
            }

            // Check if CAN address has been changed
            if(change_node_id == 1){
                reset_node_id();
                setState(&mbed_master_Data, Stopped);             // Stop the node, to change the node ID
                setNodeId(&mbed_master_Data, nodeID);             // Now the CAN adress is changed
                setState(&mbed_master_Data, Initialisation);      // Set to Pre_operational, master must boot it again
                setState(&mbed_master_Data, Operational);
                stack_state = reset;
            }

            // other events
            //sendPDOevent (&mbed_master_Data);
        }
    }
}

// ISR for the Ticker
void serviceSysTimer()
{
    // just used for debugging purposes
    serviceHelper();
    // set a flag cleared by the main loop
    timer_interrupt = 1;
}

