
#include "PCA9534.h"

char PCA9534::readRegister(char reg)
{
    char msg[2] = {reg, 0};
    _i2c->write(_address, msg, 1, 1);
    _i2c->read((_address|1), msg, 1);
    return msg[0];
}

int PCA9534::writeRegister(char reg, char val)
{
    char msg[] = {reg, val};
    return _i2c->write(_address, msg, 2);
}

void PCA9534::irqHandler(void)
{
    // IO state change. Figure out what happened. read clears
}

PCA9534::PCA9534(I2C &i2c, char address, InterruptIn &irq)
{
    _i2c = &i2c;
    _address = (0x40 | (address<<1));
    _i2c->frequency(400000);
    _irq = &irq;
    if (_irq != 0) {
        _irq->fall(this, &PCA9534::irqHandler);
    }
}

int PCA9534::input(char val)
{
    return writeRegister(3, val);
}

int PCA9534::input(BIT_LOC bit)
{
    return input((1<<bit));
}

int PCA9534::output(char val)
{
    return writeRegister(3, ~val);
}

int PCA9534::output(BIT_LOC bit)
{
    return output(~(1<<bit));
}

int PCA9534::read(void)
{
    return readRegister(0);
}

int PCA9534::read(BIT_LOC bit)
{
    char val = readRegister(0);
    return ((val&(1<<bit))==(1<<bit)) ? 1 : 0;
}

int PCA9534::write(char val)
{
    return writeRegister(1, val);
}

int PCA9534::write(BIT_LOC bit)
{
    char val = readRegister(1);
    return write(val | (1<<bit));
}
