
#ifndef PCA9534_H
#define PCA9534_H

#include "mbed.h"

class PCA9534
{
private:
    I2C *_i2c;
    InterruptIn *_irq;
    int  _address;

    enum BIT_LOC {
        B0, B1, B2, B3, B4, B5, B6, B7
    };

private:
    char readRegister(char reg);
    int writeRegister(char reg, char val);
    void irqHandler(void);

public:
    PCA9534(I2C &i2c, char address, InterruptIn &irq);
    int input(char val);
    int input(BIT_LOC bit);
    int output(char val);
    int output(BIT_LOC bit);
    int read(void);
    int read(BIT_LOC bit);
    int write(char val);
    int write(BIT_LOC bit);

};

#endif
