/**
 * @file    Oem615.cpp
 * @brief   Device driver - Novatel OEM615 GPS
 * @author  sam grove
 * @version 1.0
 * @see     http://www.novatel.com/support/firmware-software-and-manuals/product-manuals-and-doc-updates/oem6-family/
 *
 * Copyright (c) 2013
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 
#include "Oem615.h"

DigitalOut led_4(LED4);

//char const msg_0[] = "RESET"; 
char const msg_1[] = "UNLOGALL COM1";
//char const msg_2[] = "SERIALCONFIG COM1 115200 n 8 1 n off";
char const msg_3[] = "LOG COM1 BESTPOSA ONTIME 1";   //messageID = 42 
char const msg_4[] = "LOG COM1 BESTVelA ONTIME 1";   //messageID = 99
char const msg_5[] = "LOG COM1 RANGEA ONTIME 1";     //messageID = 43
//char const msg_6[] = "LOG COM1 TIMEB ONTIME 1";      //messageID = 101
char const msg_7[] = "SERIALCONFIG COM1 9600 n 8 1 n off";
char const msg_8[] = "FREQUENCYOUT ENABLESYNC 100000 1000000";
//char const msg_9[] = "CLOCKADJUST DISABLE";

DigitalOut led_2(LED2);
DigitalOut led_3(LED3);

Oem615::Oem615(Serial &uart, DigitalOut &rst, DigitalOut &pwr, InterruptIn &pps, InterruptIn &varf)
{

    _uart = &uart;
    _rst = &rst;
    _pwr = &pwr;
    _pps = &pps;
    _varf = &varf;
    
    return;
}

void Oem615::init(void)
{
    _rst->write(0);
    _pwr->write(1);
    _pps->mode(PullUp);
    _varf->mode(PullUp);
    
    _uart->baud(9600);
    
    return;
}

void Oem615::enable(void)
{
    LOG("Configuring OEM615 GPS receiver\n");
    
    _rst->write(1);
    _pwr->write(0);
    for(int i=0; i<5; ++i)
    {
        LOG("GPS ready in %d\n", (5-i));
        wait(1.0f);
    }
        
    LOG("%s\n", msg_7);
    _uart->printf("%s\n", msg_7);
    wait_ms(500);
    
    LOG("%s\n", msg_1);
    _uart->printf("%s\n", msg_1);
    wait_ms(500);
    
    LOG("%s\n", msg_3);
    _uart->printf("%s\n", msg_3);
    wait_ms(500);
    
    LOG("%s\n", msg_4);
    _uart->printf("%s\n", msg_4);
    wait_ms(500);

    LOG("%s\n", msg_5);
    _uart->printf("%s\n", msg_5);
    wait_ms(500);
    
//    LOG("%s\n", msg_9);
//    _uart->printf("%s\n", msg_h9);
//    wait_ms(500);

    LOG("%s\n", msg_8);
    _uart->printf("%s\n", msg_8);
    wait_ms(500);
    
//    LOG("%s\n", msg_2);
//    _uart->printf("%s\n", msg_2);
//    _uart->baud(115200);
//    wait_ms(500);

    // power up complete - enable the handlers
    _from_pps.start();
    _pps->rise(this, &Oem615::ppsHandler);
    _varf->rise(this, &Oem615::varfHandler);
    _uart->attach(this, &Oem615::uartRxHandler, Serial::RxIrq);
    
    return;
}

void Oem615::disable(void)
{
    _pps->rise(NULL);
    _varf->rise(NULL);
    _uart->attach(NULL, Serial::RxIrq);
    _from_pps.stop();
    _rst->write(0);
    _pwr->write(1);
    
    return;
}

void Oem615::ppsHandler(void)
{
    _from_pps.reset();
    led_2 = !led_2;
    
    return;
}

void Oem615::varfHandler(void)
{
    static int cnt = 0;
    ++cnt;
    led_3 = (cnt%10) ? 0 : 1;
    
    return;
}

void Oem615::uartRxHandler(void)
{
    while(1 == _uart->readable())
    {
        _rxbuf.data[_rxbuf.loc] = _uart->getc();
        ++_rxbuf.loc;
        // protect the buffer from spilling over
        _rxbuf.loc &= GPS_RXBUF_MASK;
    }
    led_4 = !led_4;
    
    return;
}



