#include "mbed.h"
#include "MPR121.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

#if defined TARGET_LPC1768 || TARGET_LPC11U24
  I2C i2c(p28, p27);
  InterruptIn irq(p26);
  MPR121 touch_pad(i2c, irq, MPR121::ADDR_VSS);

#elif defined TARGET_KL25Z
  I2C i2c(PTC9, PTC8);
  InterruptIn irq(PTA5);
  MPR121 touch_pad(i2c, irq, MPR121::ADDR_VSS);

#else
  #error TARGET NOT TESTED
#endif

int main() 
{       
    touch_pad.init();
    touch_pad.enable();
    touch_pad.registerDump(pc);
    
    while(1)
    {
        if(touch_pad.isPressed())
        {
            uint16_t button_val = touch_pad.buttonPressed();
            printf("button = 0x%04x\n", button_val);
            myled = (button_val>0) ? 1 : 0;
        }            
    }
}

