#include "mbed.h"
#include "IAP.h"

DigitalOut led(LED1);

char *readUUID(void)
{
    static char buf[64] = {0};
    IAP iap;
    int32_t *block = iap.read_serial();
    uint32_t serial_number[5] = {0};
    
    memset(buf, 0, sizeof(buf));
    serial_number[0] = *(block);
    serial_number[1] = *(block+1);
    // we only want bottom 16 bits of word1 (MAC bits 32-47)
    // and bit 9 forced to 1, bit 8 forced to 0
    // Locally administered MAC, reduced conflicts
    // http://en.wikipedia.org/wiki/MAC_address
    serial_number[0] |= 0x00000002;
    serial_number[0] &= 0x0000FFFE;
 
    snprintf(buf, 16, "%4X%08X", serial_number[0], serial_number[1]);
    
    return buf;
}    

int main(void)
{
    printf("%s\n", readUUID());
    
    while(1) {
        led = !led;
        wait(0.5f);
    }
}
