/**
 * @file    CommHandler.cpp
 * @brief   Core Utility - Manage ASCII communication between devices
 * @author  sam grove
 * @version 1.0
 * @see     
 *
 * Copyright (c) 2013
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "CommHandler.h"
#include <string.h>

CommHandler::CommHandler( void )
{
    return;
}

void CommHandler::attachMsg( char *string, char *(*function)(char *) )
{
    MsgObj *new_node = new MsgObj [1];
    // make sure the new object was allocated
    if (0 == new_node)
    {
        ERROR("Memory Allocation Failed\n");
    }
    // store the user parameters
    new_node->string = string;
    new_node->handler.attach( function );
    // and insert them into the list
    _list.append(new_node);

    return;
}

char *CommHandler::serviceMessage( char* buffer )
{
    uint32_t cnt = _list.length();
    node *item;
    MsgObj *tmp_data;

    for(uint32_t i=1; i<=cnt; ++i)
    {
        item = _list.pop(i);
        tmp_data = (MsgObj *)item->data;
        // Test the input against the stored record
        if( 0 ==  memcmp( buffer, tmp_data->string, strlen(tmp_data->string) ) )
        {
            return tmp_data->handler( buffer );
        }
    }

    return 0;
}

char *CommHandler::messageLookup( uint32_t const loc )
{
    node *tmp_item = _list.pop( loc );
    
    if(0 == tmp_item)
    {
        return 0;
    }
    
    MsgObj *tmp_data = (MsgObj *)tmp_item->data;

    return tmp_data->string;
}

