/*
 / _____)             _              | |
( (____  _____ ____ _| |_ _____  ____| |__
 \____ \| ___ |    (_   _) ___ |/ ___)  _ \
 _____) ) ____| | | || |_| ____( (___| | | |
(______/|_____)_|_|_| \__)_____)\____)_| |_|
    (C)2015 Semtech

Description: End device commissioning parameters

License: Revised BSD License, see LICENSE.TXT file include in the project

Maintainer: Miguel Luis and Gregory Cristian
*/
#ifndef __LORA_COMMISSIONING_H__
#define __LORA_COMMISSIONING_H__

/*!
 * When set to 1 the application uses the Over-the-Air activation procedure
 * When set to 0 the application uses the Personalization activation procedure
 */
#define OVER_THE_AIR_ACTIVATION                     0

/*!
 * Indicates if the end-device is to be connected to a private or public network
 */
#define LORAWAN_PUBLIC_NETWORK                      true

/*!
 * IEEE Organizationally Unique Identifier ( OUI ) (big endian)
 * \remark This is unique to a company or organization
 */
#define IEEE_OUI                                    0x11, 0x22, 0x33

/*!
 * Mote device IEEE EUI (big endian)
 */
#define LORAWAN_DEVICE_EUI                          { 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88 }

/*!
 * Application IEEE EUI (big endian)
 */
#define LORAWAN_APPLICATION_EUI                     { 0x00, 0x80, 0x00, 0x00, 0xA0, 0x00, 0x00, 0x80 }

/*!
 * AES encryption/decryption cipher application key
 */
#define LORAWAN_APPLICATION_KEY                     { 0x2B, 0x7E, 0x15, 0x16, 0x28, 0xAE, 0xD2, 0xA6, 0xAB, 0xF7, 0x15, 0x88, 0x09, 0xCF, 0x4F, 0x3C }

/*!
 * Current network ID
 */
#define LORAWAN_NETWORK_ID                          0

/*!
 * Device address on the network (big endian)
 */
#define LORAWAN_DEVICE_ADDRESS                      0x00000002

/*!
 * AES encryption/decryption cipher network session key
 */
#define LORAWAN_NWKSKEY                             { 0x2A, 0x91, 0xD4, 0xE6, 0x6B, 0x55, 0x4A, 0x40, 0x1A, 0xE7, 0xD3, 0x7D, 0x47, 0x95, 0xD2, 0x37 }

/*!
 * AES encryption/decryption cipher application session key
 */
#define LORAWAN_APPSKEY                             { 0x6D, 0x31, 0xDF, 0x5B, 0x8B, 0x8E, 0x87, 0x00, 0x20, 0xBC, 0x1C, 0x2F, 0x89, 0xA6, 0xAD, 0x9D }

#endif // __LORA_COMMISSIONING_H__

//99    0x65, 0x6A, 0x43, 0x5E, 0x15, 0x3E, 0x5F, 0x23, 0xCF, 0x0C, 0x11, 0x77, 0x30, 0x83, 0xA3, 0x5D
 //     0x3C, 0xC4, 0xFE, 0xAD, 0x9B, 0xC7, 0x7D, 0x9F, 0xCF, 0x9D, 0x0A, 0xE0, 0x96, 0x2F, 0xF1, 0xFD
// 88   0x2A, 0x91, 0xD4, 0xE6, 0x6B, 0x55, 0x4A, 0x40, 0x1A, 0xE7, 0xD3, 0x7D, 0x47, 0x95, 0xD2, 0x37
//      0x6D, 0x31, 0xDF, 0x5B, 0x8B, 0x8E, 0x87, 0x00, 0x20, 0xBC, 0x1C, 0x2F, 0x89, 0xA6, 0xAD, 0x9D