#include "mbed.h"
#include "keypad.h"
#include "TextLCD.h"
#include "stdlib.h"
 
TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7
AnalogIn y(PTB0);
AnalogOut u(PTE30);
int C1=0x0F;        // Cursor
int C4=0x0C;        // quito cursor bajo
int spnro=0,kinro=0,kpnro=0,kdnro=0,posicion=1,tecla,flag1=1,numero=0;                                                      
float pid, err, ap, ai, yr,ad, err_v, spf,kif,kpf,kdf,medida,pidn;
int flagt=0,com=0;
Timer t;
char cadena[3]={' ',' ',' '};
//int compl=0; //verificar que la entrada es de 3 numeros

char Keytable[] = { '1', '2', '3', 'A',
                    '4', '5', '6', 'B',
                    '7', '8', '9', 'C',
                    '*', '0', '#', 'D'
                  };
 
uint32_t cbAfterInput(uint32_t index) {
    tecla=index;
    flag1=0;
    return 0;
}


int main() {
    Keypad keypad(PTA2, PTD4, PTD3, PTD7,PTA13, PTD5, PTD0, PTD2);
    ini1:
    err=0; medida=0; yr=0; pid=0; ap=0; ai=0; ad=0; err_v=0;pidn=0;
    lcd.cls(); // Borrar Pantalla
    lcd.writeCommand(C1);//escribimos un comando segun el manual del modulo LCD
 
    lcd.locate(7,0);
    lcd.printf("Kp=%d",kpnro);
    lcd.locate(0,1);
    lcd.printf("Ki=%d",kinro);
    lcd.locate(8,1);
    lcd.printf("Kd=%d",kdnro);
    lcd.locate(0,0);
    lcd.printf("Sp=%d",spnro);
    
    ini2:
    keypad.CallAfterInput(&cbAfterInput);
    keypad.Start();
    if(flag1==0){
        if(Keytable[tecla]=='B'){       //incrementa 
            cadena[0]=' ';cadena[1]=' ';cadena[2]=' ';
            com=0;
            numero=0;
            if(posicion==4){
                posicion=1;}
            else {
                posicion++;}
        }
        else if(Keytable[tecla]=='A'){      //decrementa
            com--;
            cadena[com]=' ';
            numero=strtod(cadena,NULL);
        }
        else if((tecla==0)||(tecla==1)||(tecla==2)||(tecla==4)||(tecla==5)||(tecla==6)||(tecla==8)||(tecla==9)||(tecla==10)||(tecla==13)){
            if(com<3){
                cadena[com]=Keytable[tecla];
                numero=strtod(cadena,NULL);
                com++;}
        }
        else if(Keytable[tecla]=='D'){      //ingresa datos para calcular 
            lcd.writeCommand(C4);//escribimos un comando segun el manual del modulo LCD para quitar cursor bajo
            lcd.cls(); //borra la pantalla
            lcd.printf("   Datos Guardados!");
            wait(1);
            lcd.cls();
            lcd.printf(" INICIANDO  PID");
            wait(1);
            
            lcd.cls();
            lcd.printf("Er=%d",err);
            lcd.locate(8,0);
            lcd.printf("Me=%d",medida);
            lcd.locate(0,1);
            lcd.printf("Sp=%d",spnro);
            lcd.locate(8,1);
            lcd.printf("Co=%d",pid);
            wait(2);
            cicloPID:
                if(Keytable[tecla]=='C'){
                    spnro=0;kinro=0;kpnro=0;kdnro=0;com=0;posicion=1;flag1=1;
                    cadena[0]=' ';cadena[1]=' ';cadena[2]=' ';
                    goto ini1;}
                medida=999*y.read();            //le        er puerto analogo y asignar a medida
                err = (spnro-medida);                              //calcula el  error en la medida        
                ap = kpnro*err;                                    //s e calcula del  proporcinal        
                if(ai<100){                                 // se verifica que  integral para que no sea muy grande 
                  ai =(kinro*err)+ai;}       //calculo del integral con su  error
                  ad = kdnro*(err-err_v); //calculo de la accion derivativa
                  pid = (ap+ai+ad); //calcula el valor del pid
                  if(pid<=0){   // se verifica que pid sea mayor a cero(no se permiten valores-
                     pid=0;}
                  if (pid > 999){   // se verifica que pid sea menor o igual la valor maximo
                    pid=999;}
                err_v = err;    //  actualiza las variables de los errores
                if(flagt==0){   // impreme las variables
                    t.start();  //inicia
                    flagt=1;}
                if(t>=0.2){
                    lcd.locate(3,0);lcd.printf("    ");
                    lcd.locate(3,0);lcd.printf("%d",err);
                    lcd.locate(11,0);lcd.printf("    ");
                    lcd.locate(11,0);lcd.printf("%d",medida);
                    lcd.locate(3,1);lcd.printf("    ");
                    lcd.locate(3,1);lcd.printf("%d",spnro);
                    lcd.locate(11,1);lcd.printf("    ");
                    lcd.locate(11,1);lcd.printf("%d",pid);
                    flagt=0;
                    t.reset();
                }


              pidn=pid/999;     //Normalizacion de la salida
              u.write(pidn);    //se envia el valor pid a puerto analogico de salida (D/A)
              wait(0.01);
            goto cicloPID;
        }            
        if(posicion==1){
            spnro=numero;
            lcd.locate(3,0);lcd.printf("    ");
            lcd.locate(3,0);lcd.printf("%d",spnro);
        }
        else if(posicion==2){
            kpnro=numero;
            lcd.locate(11,0);lcd.printf("    ");
            lcd.locate(11,0);lcd.printf("%d",kpnro);
        }
        else if(posicion==3){
            kinro=numero;
            lcd.locate(3,1);lcd.printf("    ");
            lcd.locate(3,1);lcd.printf("%d",kinro);
        }
        else if(posicion==4){
            kdnro=numero;
            lcd.locate(11,1);lcd.printf("    ");
            lcd.locate(11,1);lcd.printf("%d",kdnro);
        }
    }
    flag1=1;
    goto ini2;        
}