#include "mbed.h"
#include <Pulse1.h>
#include "TextLCD.h"

 
TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7
PulseInOut irda(PTD5);
Serial pc(USBTX, USBRX);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
 
int header =0;
const int head_H = 10884; //+20% medida con osciloscopio en microsegundos (cabecera)
const int head_L = 7256;//-20%  medida con osciloscopio
int i=0;
const int T_alto=1670;//ponga su tiempo de la prueba
const int T_bajo=533;//ponga su tiempo de la prueba
const int num_bits = 32;//ponga su numero de bits
int num[num_bits];//cadena para almacenar todos los tiempos que conforman los bits de datos
int dato; // tiempo de cada dato que se lee
int n1[32],n2[32],n3[32];
int cont1,cont2,cont3;
int main(){
    //tecla1
    n1[0]=n1[5]=n1[6]=n1[9]=n1[10]=n1[12]=n1[14]=n1[15]=n1[18]=n1[24]=n1[25]=n1[27]=n1[28]=n1[29]=n1[30]=1; 
    n1[1]=n1[2]=n1[3]=n1[4]=n1[7]=n1[8]=n1[11]=n1[13]=n1[16]=n1[17]=n1[19]=n1[20]=n1[21]=n1[22]=n1[23]=n1[26]=0;n1[31]=0;   
    n2[0]=n2[5]=n2[6]=n2[9]=n2[10]=n2[12]=n2[14]=n2[15]=n2[17]=n2[24]=n2[26]=n2[27]=n2[28]=n2[29]=n2[30]=1; 
    n2[1]=n2[2]=n2[3]=n2[4]=n2[7]=n2[8]=n2[11]=n2[13]=n2[16]=n2[18]=n2[19]=n2[20]=n2[21]=n2[22]=n2[23]=n2[25]=0;n2[31]=0;   
    n3[0]=n3[5]=n3[6]=n3[9]=n3[10]=n3[12]=n3[14]=n3[15]=n3[16]=n3[18]=n3[25]=n3[27]=n3[28]=n3[29]=n3[30]=1; 
    n3[1]=n3[2]=n3[3]=n3[4]=n3[7]=n3[8]=n3[11]=n3[13]=n3[17]=n3[19]=n3[20]=n3[21]=n3[22]=n3[23]=n3[24]=n3[26]=0;n3[31]=0;   
                                    
    cont1=cont2=cont3=0;
    led1=1;
    led2=1;
    led3=1;
            
    while(1){
        ini1: header=0;
        header = irda.read_low_us();    //funcion para leer un pulso de caida o bajo
        if (header > head_L && header < head_H) goto seguir;//verificar que este en la tolerancia +-20%
        else goto ini1;
      
        seguir:
        wait_us(2000);
 
        for(i=0;i<(num_bits-1);++i){ // POR OSCILOSCOPIO se determina que llegan (num_bits),datos
            dato = irda.read_low_us(); //leer un bit de datos que es pulso arriba en este control
            num[i]=dato;
            wait_us(633);   
        }
        
        wait(0.5);//spero un poquito antes de leer todo el arreglo y ponerlo en pantalla 
 
        for(i=0;i<(num_bits-1);++i){  
            if(num[i] > ((T_alto+T_bajo)/2)) {
            num[i]=1;
            //led1=0;
            }
            else num[i]=0;
            //led1=0;
        }
        for(i=0;i<(num_bits-1);++i){
            if(num[i]==n1[i]){
            cont1++;
            led2=0;
           } 
        }
        led2=1;
            if(cont1==31){
            led1=0;
            lcd.cls(); // Borrar Pantalla
            lcd.locate(0,0);
            lcd.printf("Ha presionado el boton 1 "); //si coincidieron todos los bits del boton 1
        }
        
        
        for(i=0;i<(num_bits-1);++i){
            if(num[i]==n2[i]){
            cont2++;
            led2=1;
            }
        }
 
        if(cont2==10){
            led2=!led2;
            lcd.cls(); // Borrar Pantalla
            lcd.locate(0,0);
            lcd.printf("Ha presionado el boton 3 "); //si coincidieron todos los bits del boton 1
        
        }
        for(i=0;i<(num_bits-1);++i){
            if(num[i]==n3[i])
            cont3++;
            led3=0;
        }
 
        if(cont3==10){
            led3=!led3;
            lcd.cls(); // Borrar Pantalla
            lcd.locate(0,0);
            lcd.printf("Ha presionado el boton 5"); //si coincidieron todos los bits del boton 1
        }
        
        cont1=0;
        cont2=0;
        cont3=0;
      }
}