#include "mbed.h"
#include "DebouncedIn.h"
#include "TextLCD.h"
#include "QEI.h"
 
AnalogIn Vin(PTB0);     //entrada de la planta
AnalogOut Vout(PTE30);      //salida hacia la planta
 
QEI wheel (PTA16, PTA17, NC, 24);   //distribucion de pines para el  encoder.
TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7
 
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
DebouncedIn button1(PTC12);     // Aumento
DebouncedIn button2(PTC13);     // Disminución
DebouncedIn button3(PTC16);     // Cambio de variable
DebouncedIn button4(PTC17);     // Reset  

int C1=0x0E; // solo muestra el curzor
int C2=0x18; // desplaza izquierda
int C3=0x1A; // desplaza derecha
int C4=0x0C; // quito cursor bajo
int i; 
int j,kp,ki,kd,sp,cont,medida,cont1,cont2,cont3;                                                      
float pid, err, ap, ai, ad, err_v, spf,kif,kpf,kdf,med;


int main() {
    
    lcd.writeCommand(C1);
    lcd.printf("Sp=0    Kp=0");
    lcd.locate(0,1);
    lcd.printf("Ki=0    Kd=0");
    lcd.locate(2,0);
    lcd.printf("=");
 
    while(1) {
      
     cont1=wheel.getPulses();           //inicia el encoder 
     if(cont1<0){
     wheel.reset();
        cont1=0; 
     }
            if(cont1!=cont2) {  
                                                
            switch(i) {
            
                case 0:
               
                    lcd.locate(2,0);
                    lcd.printf("=     ");
                    lcd.locate(3,0);
                    lcd.printf("%d",cont1);
                    sp=cont1;
                    
                    break;
                case 1:
               
                    lcd.locate(10,0);
                    lcd.printf("=     ");
                    lcd.locate(11,0);
                    lcd.printf("%d",med);
                    kp=medida;
                    break;
                case 2:
                    lcd.locate(2,1);
                    lcd.printf("=     ");
                    lcd.locate(3,1);
                    lcd.printf("%d",med);
                    ki=med;
                    break;
                case 3:
                    lcd.locate(10,1);
                    lcd.printf("=     ");
                    lcd.locate(11,1);
                    lcd.printf("%d",med);
                    kd=med;
                    break;
            }
            cont2=cont1;
            
        }
                  
        
        if(button3.falling()) {         //al oprimir  el encoder
        wheel.reset();
            i++;
            if(i>3) {
                i=0;
            }
            switch (i) {
                case 0:
                    lcd.locate(2,0);
                    lcd.printf("=");
                    break;
                case 1:
                    lcd.locate(10,0);
                    lcd.printf("=");
                    break;
                case 2:
                    lcd.locate(2,1);
                    lcd.printf("=");
                    break;
                case 3:
                    lcd.locate(10,1);
                    lcd.printf("=");
                    break;
            }
        }       
    
              
           if (button4.falling()){
                    lcd.locate(0,1);
                    lcd.printf("Ha salido del programa ");
           break;     
               }
                        
                                        }
        
    lcd.writeCommand(C4);
           led3=1;
           led3= !led3;
           lcd.cls();
           lcd.printf(" DATOS GUARDADOS!");   
           wait(0.8);
           lcd.cls();
           lcd.printf("INICIANDO EL PID");
           wait(0.2);           
           lcd.cls();
           lcd.printf("Er%d",err);
           lcd.locate(8,0);
           lcd.printf("Med%d",med);
           lcd.locate(0,1);
           lcd.printf("Sp%d",sp);
           lcd.locate(8,1);
           lcd.printf("pid%d",pid);
           wait(0.5);
           
           // CICLO PRINCIPAL CONTROLADOR PID
              while(1) {
                             
           med=Vin.read();
           medida=med*100;
           kpf=kp*0.001;
           kif=ki*0.001;
           kdf=kd*0.0001;
           err = (sp-medida);
           
           ap = kpf*err;         
           ai =(kif*err)+ai;             //calculo de la integral del error
            ad = kdf*(err-err_v);        //calculo de la accion derivativa
           err_v=err;                    //guarda el error
           pid = (ap+ai+ad);
           
                       
            if (pid > 99){
           pid=100;
           } 
           
                  
           if (pid <0){
           pid=0;
           } 
           
           wait(.5);
            
           
           
                    // se verifica que la accion integral no sea muy grande
           if (ai > 999){
           ai=1000;
           } 
          
           
           Vout=pid;
           
                   
           lcd.locate(2,0);
           lcd.printf("      "); 
           lcd.locate(0,0);
           lcd.printf("Er%2.2f",err);
           lcd.locate(10,0);
           lcd.printf("      ");
           lcd.locate(8,0);
           lcd.printf("Me%d",medida);
           lcd.locate(2,1);
           lcd.printf("      ");
           lcd.locate(0,1);
           lcd.printf("Sp%d",sp);
           lcd.locate(10,1);
           lcd.printf("      ");
           lcd.locate(8,1);
           lcd.printf("Pid%4.2f",pid);
           cont=0;
           }
   }



