#include "mbed.h"
#include "LM75B.h"
#include "C12832.h"

C12832 lcd(p5, p7, p6, p8, p11);

LM75B sensor(p28,p27);
Serial pc(USBTX,USBRX);
DigitalIn JoyLeft(p13);
DigitalIn JoyRight(p16);
DigitalIn JoyButton(p14);
DigitalOut AlarmLED(LED1);

int main (){
    lcd.cls();                                                                              //clear LCD screen
    lcd.locate(0,0);                                                                        //home the lcd screen
    lcd.printf("Killian's LM75 Temperature Sensor Detection");                              //Text
    wait(2);                                                                                //pause for visibility
    int tempselect=0;                                                                       //set temp selection as undetermined
    
    while (tempselect==0){                                                                     //while temp selection undetermined
        lcd.cls();                                                                              //clear LCD screen
        lcd.locate(0,0);                                                                        //home the lcd screen
        lcd.printf("Deg. C = Joystick <\nDeg. F = Joystick >\nBoth = Joystick Button");
        if(JoyLeft==1 and JoyRight==0 and JoyButton==0){
            lcd.cls();                                                                          //clear LCD screen
            lcd.locate(0,0);                                                                    //home the lcd screen
            lcd.printf("Deg. C Selected\nPlease Wait...");                                      //selection text              
            tempselect=1;                                                                       //ammend selection constant - breaks while loop
            wait(1);                                                                            //pause for visibility and debounce
        }
        else if(JoyLeft==0 and JoyRight==1 and JoyButton==0){
            lcd.cls();                                                                          //clear LCD screen
            lcd.locate(0,0);                                                                    //home the lcd screen
            lcd.printf("Deg. F Selected\nPlease Wait...");                                      //selection text              
            tempselect=2;                                                                       //ammend selection constant - breaks while loop
            wait(1);                                                                            //pause for visibility and debounce
        }
        else if(JoyLeft==0 and JoyRight==0 and JoyButton==1){
            lcd.cls();                                                                          //clear LCD screen
            lcd.locate(0,0);                                                                    //home the lcd screen
            lcd.printf("Deg. C and Deg. F Selected\nPlease Wait...");                           //selection text              
            tempselect=3;                                                                       //ammend selection constant - breaks while loop
            wait(1);                                                                            //pause for visibility and debounce
        }
    }
   
    //Try to open the LM75B
    if (sensor.open()) {
        printf("Device detected!\n");

        while (1) {
            /* setting temperature range as between 0C and 30C, or 32F to 86F, using y=mx+c.
            for Celsius tempC=30sensor+0
            for Fahrenheit tempF=54sensor+32 */
            float tempC=30*(float)sensor;                                                         //creating Celsius selection value
            float tempF=54*(float)sensor+32;                                                      //creating Fahrenheit selection value
            
            if(tempselect==1){                                                              //if deg. C selected
                lcd.cls();                                                                  //clear LCD screen
                lcd.locate(0,0);                                                            //home LCD screen
                lcd.printf("Temp = %.1f Deg. C\n", tempC);                                  //print temp info
                wait(1.0);                                                                  //pause for visibility
            }
            else if(tempselect==2){                                                         //if deg. F selected
                lcd.cls();                                                                  //clear LCD screen
                lcd.locate(0,0);                                                            //home LCD screen
                lcd.printf("Temp = %.1f Deg. F\n", tempF);                                  //print temp info
                wait(1.0);                                                                  //pause for visibility
            }
            else if(tempselect==3){                                                         //if both temps selected
                lcd.cls();                                                                  //clear LCD screen
                lcd.locate(0,0);                                                            //home LCD screen
                lcd.printf("Temp = %.1f Deg. C\nTemp = %.1f Deg. F", tempC, tempF);         //print both temp infos
                wait(1.0);                                                                  //pause for visibility
            }
            
            if(tempC>=27.0){                                                                //High temp alarm set for 27 degrees C or over
                lcd.cls();                                                                  //clear LCD screen
                lcd.locate(0,0);                                                            //home LCD screen
                lcd.printf("Warning - Temperature High Alarm!");                            //display alarm text
                AlarmLED=1;                                                                 //toggle on alarm LED
                wait(1);                                                                    //pause while LED lit
                AlarmLED=0;                                                                 //clear the alarm LED
            }
            
        } // end of while loop
        
    } // the end of if statment
    
    else {
        error("Device not detected!\n");
    } 

} // end of main
