// including necessary header folders
#include"mbed.h"
#include"C12832.h"

// declaring necessary components and variables
Serial pc(USBTX,USBRX);                             //USB tx,rx
C12832 lcd(p5,p7,p6,p8,p11);                        //Breakout board lcd

AnalogIn lvl(p19);                                  //pot1 level sensor
AnalogIn temp(p20);                                 //pot2 temperature sensor

DigitalIn start(p15);                               //joystick up start button
DigitalIn prod(p13);                                //joystick left product detected in tank (simulates sensor input)
DigitalOut invalve(LED1);                           //LED1 represents an input valve to fill the tank - open is true
DigitalOut outvalve(LED2);                          //LED2 represents an output valve to empty the tank - open is true
DigitalOut heatstir(LED3);                          //LED3 represents an heater and stirrer to maintain temp and stir the tank - on is true
DigitalOut sysrun(LED4);                            //LED4 represents a Clear To Run signal outputted to system to allow product loading - on is true
Timer debounce;

InterruptIn emo(p14);                               //joystick button EMO activation button (Interrupt)
InterruptIn stop(p12);                              //joystick down stop button (Interrupt)

/* criteria set for tank level between 0 and 25 litres, temperature between 0 and 200 degrees C.
Low/High levels represent acceptable manufacturing level. Critical levels will indicate system/equipment failure and dump tank.
Chemical lifespan is set to 50 hours of production and production time for each lot in tool is 1.5hrs */
float lvlset=20.0, lvllo=15.0, lvlhi=23.0, lvlhihi=24.0;                    // tank level criteria - current level, setpoint, lowest level, high level, critical high
float tmpset=150.0, tmplo=130.0, tmphi=170.0, tmphihi=190.0;                // tank temperature criteria - current temp, setpoint, lowest level, high level, critical high
float tanklife=50.0, prodtime=1.5;                                          // production criteria - lifespan of chemicals, production time per lot
int ctf=0, cth, ctr, prodpres;                                              // flags for clear to fill, clear to heat, clear to run, product in tank - in all cases clear is true

// Interrupt program for Emergency Manual Overide activation
void override(){
    debounce.start();               // start the timer
    invalve=0;                      // close input valve
    outvalve=1;                     // dump tank
    heatstir=0;                     // stop heater
    ctf=0;                          // clear to fill to false
    cth=0;                          // clear to heat to false
    ctr=0;                          // clear to run to false
    lcd.cls();                      // clear LCD screen
    lcd.locate(0,0);                // home the lcd screen
    lcd.printf("EMO activated!\nContact Equipment Group!\nDumping Tank");       //print emo text on LCD
    pc.printf("EMO activated! Contact Equipment Group! Dumping Tank\n\r");      //print emo text on pc
    if (debounce.read_ms() >= 500){ // determine the timer limits - greater than or equal incase the exact count was missed by timer               
        debounce.reset();           // reset the timer for the next use
    }
    
}

// Interrupt program for Stop button activation
void halt(){
    debounce.start();               // start the timer
    invalve=0;                      // close input valve
    outvalve=0;                     // close output valve
    heatstir=0;                     // stop heater
    ctf=0;                          // clear to fill to false
    cth=0;                          // clear to heat to false
    ctr=0;                          // clear to run to false
    lcd.cls();                      // clear LCD screen
    lcd.locate(0,0);                // home the lcd screen
    lcd.printf("Stop Pressed!\nContact Equipment Group!\nHold to verify");                  //print stop text on LCD
    pc.printf("Stop Pressed! Contact Equipment Group! Hold to verify production ok!\n\r");  //print stop text on pc
    if (debounce.read_ms() >= 500){ // determine the timer limits - greater than or equal incase the exact count was missed by timer               
        debounce.reset();           // reset the timer for the next use
    }
    
}

// Start of main program
int main(){
    // define emo interrupt
    emo.rise(&override);     //attach the function address to the rising edge
    // define Stop interrupt
    stop.rise(&halt);     //attach the function address to the rising edge

    
    while(1){                               //always on loop
        float level=25.0*lvl+0;             //define the current tank level (y=mx+c)
        float temperature=200.0*temp+0;     //define the current tank temperature (y=mx+c)
        
        // initial start conditions are an error or a start button press
        if(ctf==0 and prod==1){                                                                     //load error detected - product in tank/sensor failure
            lcd.cls();                                                                              //clear LCD screen
            lcd.locate(0,0);                                                                        //error - home the lcd screen
            lcd.printf("System Error!\nContact Equipment Group!\nProduct detected in tank!");       //error - print error text on LCD
            pc.printf("System Error! - Contact Equipment Group! - Product detected in tank!\n\r");  //error - print error text via terraterm to pc
            }
        if(ctf==0 and start==1){                                                                    //start button goes true (momentary)
            ctf=1;                                                                                  //clear to fill flag goes true (set)
            lcd.cls();                                                                              //clear LCD screen
            lcd.locate(0,0);                                                                        //home LCD screen
            lcd.printf("Start Button Pressed");                                                     //print start text on LCD
            pc.printf("Start Button Pressed\n\r");                                                  //clear to fill flag goes true (set) - only stop/emo/dump will unset this
            wait(0.5);                                                                              //debounce delay                                       
            }
        
        //if cleared to fill various states are possible based upon volume detected
        if(ctf==1){                                                                                             //clearance given to run

            if(level<lvllo){                                                                                    //tank below lowest usable level
                invalve=1;                                                                                      //open the input valve
                outvalve=0;                                                                                     //close the output valve
                cth=0;                                                                                          //heat/stir flag set to false
                lcd.cls();                                                                                      //LCD screen cleared
                lcd.locate(0,0);                                                                                //LCD homed
                lcd.printf("Level: %2.1f\nTemp: %3.1f\nTank Filling",level,temperature);                        //status to LCD
                pc.printf("Tank level: %2.1f, Tank temperature: %3.1f, Tank filling\n\r",level,temperature);    //status to pc
                wait(1);                                                                                        //pause for 1 second to prevent flood of data
                }
            else if(level<lvlset){                                                                              //minimum usable volume reached, heating now allowed
                invalve=1;                                                                                      //filling to setpoint
                outvalve=0;                                                                                     //closed output valve
                cth=0;                                                                                          //clear to heat flag goes true (set)
                lcd.cls();                                                                                      //LCD screen cleared
                lcd.locate(0,0);                                                                                //LCD homed
                lcd.printf("Level: %2.1f\nTemp: %3.1f\nTank Level Low",level,temperature);                      //status to LCD
                pc.printf("Tank level: %2.1f, Tank temperature: %3.1f, Tank level low\n\r",level,temperature);  //status to pc
                wait(1);                                                                                        //pause for 1 second to prevent flood of data
                }
            else if(level<lvlhi){                                                                               //volume setpoint reached
                invalve=0;                                                                                      //input valve closed
                outvalve=0;                                                                                     //output valve remains closed
                cth=1;                                                                                          //clear to fill flag remains true
                lcd.cls();                                                                                      //LCD screen cleared
                lcd.locate(0,0);                                                                                //LCD homed
                lcd.printf("Level: %2.1f\nTemp: %3.1f\nAt Level Setpoint",level,temperature);                           //status to LCD
                pc.printf("Tank level: %2.1f, Tank temperature: %3.1f, Tank at level setpoint\n\r",level,temperature);  //status to pc
                wait(1);                                                                                                //pause for 1 second to prevent flood of data
                }
            else if(level<lvlhihi){                                                                             //warning state - volume goes high enough to flag - possible ceased input valve/system error
                invalve=0;                                                                                      //input valve off command reconfirmed
                outvalve=1;                                                                                     //output valve opened to release volume
                cth=0;                                                                                          //clear to heat flag goes false (set)
                lcd.cls();                                                                                      //LCD screen cleared
                lcd.locate(0,0);                                                                                //LCD homed
                lcd.printf("Level: %2.1f\nTemp: %3.1f\nTank Level High!",level,temperature);                                //status to LCD
                pc.printf("Tank level: %2.1f, Tank temperature: %3.1f, Tank Level High Warning!\n\r",level,temperature);    //status to pc
                wait(1);                                                                                                    //pause for 1 second to prevent flood of data
                }
            else if(lvlhihi<=level){                                                                            //critical state - critical volume detected, overflow risk - emergency dump
                invalve=0;                                                                                      // input valve closed
                outvalve=1;                                                                                     //output valve open to dump
                cth=0;                                                                                          //clear to heat flag remains false
                ctf=0;                                                                                          //clear to fill flag goes false - tool returned to start conditions
                lcd.cls();                                                                                      //LCD screen cleared
                lcd.locate(0,0);                                                                                //LCD homed
                lcd.printf("Level: %2.1f\nTemp: %3.1f\nLevel Critical! Tank Dump",level,temperature);                               //status to LCD
                pc.printf("Tank level: %2.1f, Tank temperature: %3.1f, Tank Overflow Risk! Dumping Tank\n\r",level,temperature);    //status to pc
                wait(1);                                                                                                            //pause for 1 second to prevent flood of data
                }
        }
                
        //if cleared to heat various states are possible based upon volume detected
        if(cth==1){                                                                                 //clearance given to run heater/stirrer

            if(temperature<tmplo){                                                                  //tank below lowest usable temperature
                heatstir=1;                                                                         //turn on the heater/stirrer
                ctr=0;                                                                              //clear to run flag set to false
                lcd.cls();                                                                          //LCD screen cleared
                lcd.locate(0,0);                                                                    //LCD homed
                lcd.printf("Level: %2.1f\nTemp: %3.1f\nTank Heating",level,temperature);                                            //status to LCD
                pc.printf("Tank level: %2.1f, Tank temperature: %3.1f, Tank Temperature Low, Heater on\n\r",level,temperature);     //status to pc
                wait(1);                                                                                                            //pause for 1 second to prevent flood of data
                }
            else if(temperature<tmpset){                                                            //minimum usable temperature reached, running now allowed
                heatstir=1;                                                                         //heating to setpoint
                ctr=1;                                                                              //clear to run flag goes true (set)
                sysrun=1;                                                                           //output to system to begin loading product
                lcd.cls();                                                                          //LCD screen cleared
                lcd.locate(0,0);                                                                    //LCD homed
                lcd.printf("Level: %2.1f\nTemp: %3.1f\nTemp Low",level,temperature);                                        //status to LCD
                pc.printf("Tank level: %2.1f, Tank temperature: %3.1f, Temperaturelow,  ok to run\n\r",level,temperature);  //status to pc
                wait(1);                                                                                                    //pause for 1 second to prevent flood of data
                }
            else if(temperature<tmphi){                                                             //temp setpoint reached
                heatstir=0;                                                                         //heater off
                ctr=1;                                                                              //clear to run flag remains true
                sysrun=1;                                                                           //output to system to begin loading product
                lcd.cls();                                                                          //LCD screen cleared
                lcd.locate(0,0);                                                                    //LCD homed
                lcd.printf("Level: %2.1f\nTemp: %3.1f\nTemp at Setpoint",level,temperature);                                    //status to LCD
                pc.printf("Tank level: %2.1f, Tank temperature: %3.1f, Tank at temperature setpoint\n\r",level,temperature);    //status to pc
                wait(1);                                                                                                        //pause for 1 second to prevent flood of data
                }
            else if(temperature<tmphihi){                                                           //warning state - temp goes high enough to flag - possible ceased heater/system error
                heatstir=0;                                                                         //input valve off command reconfirmed
                ctr=0;                                                                              //clear to heat flag goes false (set)
                lcd.cls();                                                                          //LCD screen cleared
                lcd.locate(0,0);                                                                    //LCD homed
                lcd.printf("Level: %2.1f\nTemp: %3.1f\nTemp High!",level,temperature);                                          //status to LCD
                pc.printf("Tank level: %2.1f, Tank temperature: %3.1f, Tank Temperature High Warning!\n\r",level,temperature);  //status to pc
                wait(1);                                                                                                        //pause for 1 second to prevent flood of data
                }
            else if(tmphihi<=temperature){                                                          //critical state - critical volume detected, overflow risk - emergency dump
                heatstir=0;                                                                         // input valve closed
                ctr=0;                                                                              //clear to run flag goes false
                cth=0;                                                                              //clear to heat flag goes false
                ctf=0;                                                                              //clear to fill flag goes false - tool returned to start conditions
                lcd.cls();                                                                          //LCD screen cleared
                lcd.locate(0,0);                                                                    //LCD homed
                lcd.printf("Level: %2.1f\nTemp: %3.1f\nTemp Critical! Tank Dump",level,temperature);                                            //status to LCD
                pc.printf("Tank level: %2.1f, Tank temperature: %3.1f, Tank Overheated, Production Risk! Dumping Tank\n\r",level,temperature);  //status to pc
                wait(1);                                                                                                                        //pause for 1 second to prevent flood of data
                }
            }
            
            if(ctr==1){                                                                             //clearance given to run heater/stirrer
               if(prod==1){                                                                         //when product arrives at station and triggers sensor
                    tanklife-=prodtime;                                                             //chemical time is reduced by set amount of production time
                    }
                lcd.cls();                                                                          //LCD screen cleared
                lcd.locate(0,0);                                                                    //LCD homed
                lcd.printf("Level: %2.1f L\nTemp: %3.1f C\nChem Time: %3.1f Hrs",level,temperature,tanklife);                           //status to LCD
                pc.printf("Tank level: %2.1f, Tank temperature: %3.1f, Remaining Chem hours: %3.1f\n\r",level,temperature,tanklife);    //status to pc
                wait(1);                                                                                                                //clearance given to run heater/stirrer
                   }
                   
                if(tanklife<=0){                                                                    //when usable lifespan of chemical expires
                    ctr=0;                                                                          //clear to run flag goes false
                    cth=0;                                                                          //clear to heat flag goes false
                    ctf=0;                                                                          //clear to fill flag goes false
                    sysrun=0;                                                                       //command to run production rescinded
                    lcd.cls();                                                                      //LCD screen cleared
                    lcd.locate(0,0);                                                                //LCD homed
                    lcd.printf("Level: %2.1f\nTemp: %3.1f\nChem Time Over, Dump!",level,temperature);                                           //status to LCD
                    pc.printf("Tank level: %2.1f, Tank temperature: %3.1f, Chemical time limit expired! Dumping Tank\n\r",level,temperature);   //status to pc
                    wait(1);                                                                                                                    //pause for 1 second to prevent flood of data
                    }
                
               
        } // while loop end
} // main end