#include "mbed.h"                                                               // mbed header
#include "LM75B.h"                                                              // temp sensor header
#include "C12832.h"                                                             // lcd screen header

C12832 lcd(p5, p7, p6, p8, p11);                                                // define lcd
LM75B sensor(p28,p27);                                                          // define tem sensor
Serial pc(USBTX,USBRX);                                                         // define serial port
LocalFileSystem local("local");                                                 // create local file system location

int seconds = 60;                                                               // define timespan variable
int i=0;                                                                        // define iteration variable
float accum = 0.0;                                                              // define temporary accumulator float
int timeDelay = 5;                                                              // define sample time range

Thread thread1, thread2, thread3;

void LM758_ok()
{
    while (1){
        if (sensor.open()) {                                                        // test if temp sensor functioning (quickly eliminated if functional)
            lcd.printf("Device detected!\n");
            }   
        else {                                                                    // if temp sensor not functioning throw an error
            error("Device not detected!\n");
        }
        
    ThisThread::sleep_for(2000);
    
    }
}
    
void display_data() 
{
    while(1){
        lcd.cls();                                                                  // clear lcd screen
        lcd.locate(0,0);                                                            // create lcd home location
        lcd.printf("Temp = %.3f\n\r", (float)sensor.temp());                             // print sensor reading to lcd
        pc.printf("Temp = %.3f degrees C\n\r", (float)sensor.temp());                      // print sensor reading to pc

        float value = (float)sensor.temp();                                                // store sensor reading as usable variable
        accum = accum + value;                                                      // begin accumulating sum of values detected
        i = i+1;
        
    ThisThread::sleep_for(5000);
    
    }
}

void log_data() 
{
    // This logging component still doesn't work, same as lab4
    while(1){
        if (i==(seconds/timeDelay)) {                                                           // define max number of iterations allowed
            float avgTemp = accum/i;                                                            // create an average value for the sensor readings
            pc.printf("Average Temp for last %d seconds = %.3f degrees C\n\r", seconds, avgTemp);        // print text of average temp reading to the pc

            // attempt to record an average temperature over a defined period to local memory - in this case every minute.
            lcd.printf("Data logging\n\r");
            FILE *fp = fopen("/local/avgTemp.txt", "a");                             // direct to txt file in local memory
            fprintf(fp,"%.5f\n", avgTemp);                                           // write average temp to local flash
            fclose(fp);                                                             // close the file
            ThisThread::sleep_for(6000);
            //
        }
    
    }
}


int main()                                                                      // start main program
{

    while (1) {                                                                 // constant loop
        thread1.start(LM758_ok);
        thread2.start(display_data);
//        thread3.start(log_data);
        
//        wait(timeDelay);                                                        // wait for desired time between readings
    }
}
