#include "mbed.h"                                                               // include mbed header

Serial pc(USBTX,USBRX);//tx,rx                                                  // include serial port

float pi = 3.14159;                                                             // define abreviated value for pi

class Shape{                                                                    // create parent class for shapes
    
protected:                                                                      // create values protected for use of child classes
    int _a, _b;                                                                 // global variables for length/radius and breadth

public:                                                                         // publicly viewable data
    Shape(int a)                                                                // constructor for single integer (square or circle)
    {
        _a = a;
    }

    Shape(int a, int b)                                                         // constructor for 2 integers (rectangle)
    {
        _a = a;
        _b = b;
    }
    
    int area()                                                                  // constructor for output
    {
        pc.printf ("Parent class area");
        return 0;
    }
    
    int perimeter()                                                                  // constructor for output
    {
        pc.printf ("Parent class perimeter");
        return 0;
    }
    
};

class Rectangle: public Shape                                                   // class for rectangles
{
public:                                                                         // linking to parent class
    Rectangle(int a, int b ):Shape(a, b) { }

    int area ()                                                                 // calculations for area
    {
        int area = _a*_b;                                                       // length * breadth
        pc.printf ("Rectangle - area : %d\n\r", area);                          // print statement
        return 0;                                                               // return class
    }
    
    int perimeter()                                                             // calculation for perimeter length
    {
        int perimeter = (2*_a)+(2*_b);                                          // 2*length + 2*breadth
        pc.printf ("Rectangle - perimeter : %d\n\r", perimeter);                // print statement
        return 0;                                                               // return class
    }
        
};

class Square: public Shape                                                      // class for squares
{
public:
    Square(int a): Shape(a) { }                                                 // linking to parent class

    int area ()                                                                 // calculations for area
    {
        int area = _a*_a;                                                       // length squared
        pc.printf ("Square - area : %d\n\r", area);                             // print statement
        return 0;                                                               // return class
    }
    int perimeter()                                                             // calculations for perimeter
    {
        int perimeter = 4*_a;                                                   // 4*length
        pc.printf ("Square - perimeter : %d\n\r", perimeter);                   // print statement
        return 0;                                                               // return class
    }
};

class Circle: public Shape                                                      // class for circles
{
public:                                                                         
    Circle(int a): Shape(a) { }                                                 // linking to parent class

    int area ()                                                                 // calculation for area
    {
        float area = pi*_a*_a;                                                  // pi r squared
        pc.printf ("Circle - area : %.2f\n\r", area);                           // print statement
        return 0;                                                               // return class
    }
    int perimeter()                                                             // calculation for circumference
    {
        float perimeter = 2*pi*_a;                                              // 2 pi r
        pc.printf ("Circle - circumference : %.2f\n\r", perimeter);             // print statement
        return 0;                                                               // return class
    }
};

// Main function for the program
int main()                                                                      // main program
{
    
    Rectangle myRectangle(10,7);                                                // call class for rectangle
    myRectangle.area();                                                         
    myRectangle.perimeter();
    
    Square mySquare(10);                                                        // Call class for square
    mySquare.area();
    mySquare.perimeter();
    
    Circle myCircle(10);                                                        // call class for circle
    myCircle.area();
    myCircle.perimeter();

}