#include "mbed.h"                                                               // mbed header
#include "LM75B.h"                                                              // temp sensor header
#include "C12832.h"                                                             // lcd screen header

C12832 lcd(p5, p7, p6, p8, p11);                                                // define lcd
LM75B sensor(p28,p27);                                                          // define tem sensor
Serial pc(USBTX,USBRX);                                                         // define serial port
LocalFileSystem local("local");                                                 // create local file system location

int seconds = 60;                                                               // define timespan variable
int i=0;                                                                        // define iteration variable
float accum = 0.0;                                                              // define temporary accumulator float
int timeDelay = 5;                                                              // define sample time range


int main()                                                                      // start main program
{

    //Try to open the LM75B
    if (sensor.open()) {                                                        // test if temp sensor functioning (quickly eliminated if functional)
        lcd.printf("Device detected!\n");

        while (1) {                                                             // constant loop
            lcd.cls();                                                          // clear lcd screen
            lcd.locate(0,3);                                                    // create lcd home location
            lcd.printf("Temp = %.3f\n\n\r", (float)sensor);                     // print sensor reading to lcd
            pc.printf("Temp = %.3f degrees C\n\r", (float)sensor);              // print sensor reading to pc

            float value = (float)sensor;                                        // store sensor reading as usable variable
            accum = accum + value;                                              // begin accumulating sum of values detected
            i = i+1;                                                            // iterate iteration variable

            if (i==(seconds/timeDelay)) {                                                           // define max number of iterations allowed
                float avgTemp = accum/i                  ;                                          // create an average value for the sensor readings
                pc.printf("Average Temp for last %d seconds = %.3f degrees C\n\r", avgTemp);        // print text of average temp reading to the pc

                /* attempt to record an average temperature over a defined period to local memory - in this case every minute.
                FILE*fp = fopen("/local/avgTemp.txt", "a");                     // direct to txt file in local memory
                fprintf(fp,"%.5f\n", avgTemp);                                  // attempt to write average temp to local flash (does not work! - looking for string. Putc also doesn't work)
                fclose(fp);                                                     // close the file
                */
                
                i=0;                                                            // reset the iteration variable to start sequence again
                accum=0.0;                                                      // reset the temporary accumulator value to start sequence again
            }

            wait(timeDelay);                                                    // wait for desired time between readings
        }

    } else {                                                                    // if temp sensor not functioning throw an error
        error("Device not detected!\n");
    }



}
