//Uses the measured z-acceleration to drive leds 2 and 3 of the mbed

#include "mbed.h"                                   // add mbed header
#include "MMA7660.h"                                // add accelerometer header
#include "C12832.h"                                 // add LCD screen header

MMA7660 MMA(p28, p27);                              // definine accelerometer
Serial pc(USBTX,USBRX);                             // define serial port tx,rx
C12832 lcd(p5, p7, p6, p8, p11);                    // define LCD screen
DigitalOut connectionLed(LED1);                     // define acc status LED
float pi = 3.14159;                                 // abbreviated value for pi

float calculatePitch(float x, float y, float z)     // define function to derive pitch angle
{
    float pitch = 0.0;                              // initialise pitch
    pitch = atan( x /sqrt((y*y)+(z*z)) );           // define pitch equation
    pitch = pitch * (180/pi);                       // ammend from radians to degrees
    return pitch;                                   // return value of pitch
}

float calculateRoll(float x, float y, float z)      // define function to derive pitch angle
{
    float roll = 0.0;                               // initialise roll
    roll = atan( y /sqrt((x*x)+(z*z)) );            // define roll equation
    roll = roll * (180/pi);                         // ammend from radians to degrees
    return roll;                                    // return value of roll
}

int main()                                                                                          // Start of main program
{
    if (MMA.testConnection())                                                                       // Test if accelerometer functional
        connectionLed = 1;                                                                          // if functional light LED1

    while(1) {                                                                                      // continuous operation
        float pitchResult = calculatePitch(MMA.x(), MMA.y(), MMA.z());                              // define value for pitch
        float rollResult = calculateRoll(MMA.x(), MMA.y(), MMA.z());                                // define value for roll
        lcd.printf("Pitch = %.4f degrees\n\r", pitchResult);                                        // print statement for pitch [mbed]
        lcd.printf("Roll = %.4f degrees\n\n\r", rollResult);                                        // print statement for roll [mbed]
        pc.printf("Pitch is %.4f degrees, and Roll is %.4f degrees\n\r", pitchResult, rollResult);  // print statement for pitch and roll [serial]
        wait(5);                                                                                    // delay of 5 seconds between iterations of program
    }

}