#include "mbed.h"   

DigitalIn fire(p14); 
PwmOut spkr(p26); 
AnalogIn pot1(p19); 

float freqmin = 2000.0;                                     // initialising the low frequency range
float freqmax = 10000.0;                                    // initialising the high frequency range
float freqchange = 100;                                     // initialising the frequency change per tone
float freqperiod = 1.0;                                     // initialising the output tone
float speakervol = 0.5;                                     // initialising the PWM output
float tonelength = 0.3;                                     // initialising the time each tone will hold

int main() 
{   
    while (1) {         
        for (float i=freqmin; i<freqmax; i+=freqchange) {             
            spkr.period(freqperiod/i);                      // PWM output frequency   
            spkr=speakervol;                                // output volume
            wait(tonelength);                               // length of each tone
        }         
        spkr=0.0;     
        freqperiod += 1.0;                                  // tone sound will deepen with each repetition
        tonelength -= 0.05;                                 // tone sound will shorten with each repetition

        while(pot1.read() < 0.5) {} // this uses the pot to control the program     
    }
}