#include"mbed.h"                    // mbed header
#include "C12832.h"                 // lcd header

InterruptIn joystickcenter(p14);    // initialise interrupt pin on pcb
InterruptIn button(p9);             // initialise external interrupt pin
DigitalOut led(LED1);               // initialise interrupt led
DigitalOut flash(LED4);             // initialise main program led
C12832 lcd(p5, p7, p6, p8, p11);    // initialise lcd
Timer debounce;                     // create debouce timer variable
int state;                          // create interrupt activation variable
int i=0;                            // create interrupt activation iterable variable

void flip(){
    debounce.start();               // start the timer
    led=!led;                       // toggles the led when the joystick button is pressed.
    state= 1;                       // changes global variable when interrupt activated
    if (debounce.read_ms() >= 500){ // determine the timer limits - greater than or equal incase the exact count was missed by timer               
        debounce.reset();           // reset the timer for the next use
    }
    
}

int main(){
    joystickcenter.rise(&flip);     //attach the function address to the rising edge
    button.mode(PullUp);            // With this, no external pullup resistor needed
    button.rise(&flip);             // attach the function address to the rising edge
    
    while(1){                       //continuous run
        if (state == 1){            // if interrupt activated
            i++;                    // iterate the variable i
            lcd.locate(0,0);        // home the lcd
            lcd.printf("Interrupt Activated x %d", i);      // add lcd text
            state = 0;              // reset the state variable from the interrupt
            }
        else                        // normal operation
        {
            flash=!flash;           // turns LED4 on ifoff, off if on
            wait(0.25);             // the instruction to wait for a quarter-second
        }
    }
}
