#include "mbed.h"
#include "MMA8451Q.h"
#include "TextLCD.h"
#define MMA8451_I2C_ADDRESS (0x1d<<1)

TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5);  //configura los puestos PTE0,PTE1,PTE2,PTE3,PTE4,PTE5, donde se conectara el LCD 16x2
MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
PwmOut rojo(LED_RED);
PwmOut verde(LED_GREEN);
PwmOut azul(LED_BLUE);

float X,Y,Z;

void imprimir(void){  //funcion que imprime los caracteres que no van a variar en el display
lcd.cls();
lcd.locate(0,0);
lcd.printf("X=%.3f",X);
lcd.locate(8,0);
lcd.printf("Y=%.3f",Y);
lcd.locate(0,1);
lcd.printf("Z=%.3f",Z);
}


int main() {
    while(1) {
        X=acc.getAccX();
        Y=acc.getAccY();
        Z=acc.getAccZ();
        imprimir();
        rojo=1.0 - abs(X);
        verde=1.0 - abs(Y);
        azul=1.0 - abs(Z);
        wait(0.1);
    }
}
