#include "mbed.h"
#include "TextLCD.h"
#include"keypad.h"
#include"FPointer.h"

TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5);  //configura los puestos PTE0,PTE1,PTE2,PTE3,PTE4,PTE5, donde se conectara el LCD 16x2
Keypad keypad(PTA2,PTD4,PTD3,PTD7,PTA13,PTD5,PTD0,PTD2);
AnalogIn Vin(PTB0);
AnalogOut Vout(PTE30);
Timer t;
int cero;
int flag;
int q;
int k;
int C1=0x0E;    //configurar el lcd para mostrar el guin bajo
int C2=0x0C;    //configurar el lcd para no mostrar el guion bajo
float s=0;       //set point
float p=0;       //ganancia proporcional
float i=0;       //ganancia integral
float d=0;       //ganancia derivativa
int ind=0;      //vector de caracteres.
float err, med, yr, ap, ai, ad, err_v, cycle;
float pid;
float  Keytable[] = {1,2,3,11,
                   4,5,6,12,
                   7,8, 9,13,
                   0,0,0,0};

void incremento(int h){             //Funcion que incremente los valores 
if(h==0){
        if (q!=1 && s<10){
        s=ind;
        q=1;
        }
        else{
         s=10*s+ind;
         }
         if(s>999)s=999;
        lcd.locate(3,0); lcd.printf("   ");
        lcd.locate(3,0); lcd.printf("%.0f",s);
        
      }
else if(h==1){
        if (q!=1 && p<10){
        p=ind;
        q=1;
        }
        else{
         p=10*p+ind;
         }
         if(p>999)p=999;
        lcd.locate(11,0); lcd.printf("   ");
        lcd.locate(11,0); lcd.printf("%.0f",p);
      }
else if(h==2){
        if (q!=1 && i<10){
        i=ind;
        q=1;
        }
        else{
         i=10*i+ind;
         }
         if(i>999)i=999;
        lcd.locate(3,1); lcd.printf("   ");
        lcd.locate(3,1); lcd.printf("%.0f",i);  
      }
else{
        if (q!=1 && d<10){
        d=ind;
        q=1;
        }
        else{
         d=10*d+ind;
         }
         if(d>999)d=999;
        lcd.locate(11,1); lcd.printf("   ");
        lcd.locate(11,1); lcd.printf("%.0f",d);
    }
    ind=0; cero=0;
}

uint32_t cbAfterInput(uint32_t index) {
    ind=Keytable[index];
    cero=index;
    return 0;
}

void def_posicion(int h){
    if (h==0){
    lcd.locate(3,0); lcd.printf("%.0f",s);
    lcd.locate(3,0); 
    }
    else if(h==1){
    lcd.locate(11,0);   lcd.printf("%.0f",p);
    lcd.locate(11,0);   
    }
    else if (h==2){
    lcd.locate(3,1); lcd.printf("%.0f",i);
    lcd.locate(3,1); 
    }
    else {
    lcd.locate(11,1);   lcd.printf("%.0f",d);
    lcd.locate(11,1);  
    }
}

void star_patch1(void){  //funcion que imprime los caracteres que no van a variar en el display
lcd.cls();
lcd.locate(8,0);
lcd.printf("Kp=%.0f",p);
lcd.locate(0,1);
lcd.printf("Ki=%.0f",i);
lcd.locate(8,1);
lcd.printf("Kd=%.0f",d);
lcd.writeCommand(C1);   //permite que el cursor se vea y sea intermitente
lcd.locate(0,0); 
lcd.printf("Sp=%.0f",s);
}

void star_patch2(void){  //funcion que imprime los caracteres que no van a variar en el display
lcd.writeCommand(C2);
lcd.cls();
lcd.printf("***INICIA PID***");    lcd.printf("****************");
wait(2);
lcd.cls();
lcd.printf("Er%=f",err);
lcd.locate(8,0);    lcd.printf("Me=%.0f",med); 
lcd.locate(0,1);    lcd.printf("Sp=%.0f",s);
lcd.locate(8,1);    lcd.printf("Co=%.0f",pid);
wait(3);
}

int main(){
star_patch1();
    keypad.CallAfterInput(&cbAfterInput);
    keypad.Start();
ini1:
  if(ind==12){
    if (k<3) k++;
    else k=0;
    def_posicion(k);
    ind=0;
    q=0;
  }
  if(ind==13){
  ind=0;
  goto PID;
  }
  if(ind==11){
    if (k==0){
    s=0;
    lcd.locate(3,0); lcd.printf("   ");
    lcd.locate(3,0); lcd.printf("%.0f",s);
    }
    else if(k==1){
    p=0;
    lcd.locate(11,0); lcd.printf("   ");  
    lcd.locate(11,0); lcd.printf("%.0f",p);
    }
    else if (k==2){
    i=0;
    lcd.locate(3,1); lcd.printf("   ");
    lcd.locate(3,1); lcd.printf("%.0f",i);
    }
    else {
    d=0;
    lcd.locate(11,1);  lcd.printf("   "); 
    lcd.locate(11,1);  lcd.printf("%.0f",d);
    }
    q=0; ind=0; 
  }
  if (ind!=0 && ind!=12 && ind!=13 && ind!=11 || cero==13 ){
  incremento(k);
  } 
  goto ini1;
    
PID:    
    star_patch2();
    
    while (1){
    
    med=Vin.read()*1000;
    err =s-med;
    ap = p*err;           
    ai =(i*0.001*err)+ai;    //calculo de la integral del error
    // se verifica que la accion integral no sea muy grande
    ad = d*(err-err_v); //calculo de la accion derivativa
    pid =(ap+ai+ad);
    //****se muestran las variables******************************************
    if (pid > 999)pid=1000; 
    if (pid<0)pid=0;
    
    
    Vout.write(pid/1000);
    if(flag==0){
    t.start();
    flag=1;
    }
    if (t>0.3){
    lcd.locate(3,0);
    lcd.printf("     ");
    lcd.locate(3,0);
    lcd.printf("%.0f",err);
    lcd.locate(11,0);
    lcd.printf("     ");
    lcd.locate(11,0);
    lcd.printf("%.0f",med);
    lcd.locate(3,1);
    lcd.printf("     ");
    lcd.locate(3,1);
    lcd.printf("%.0f",s);
    lcd.locate(11,1);
    lcd.printf("     ");
    lcd.locate(11,1);
    lcd.printf("%.2f ",pid/1000);
    t.reset();
    flag=0;
    wait(.3);
    }
    // se actualizan las variables *******************************************
    err_v = err;
    }
}