#include "mbed.h"
#include <Pulse1.h>
 
PulseInOut irda(PTD5);// en este puerto se pone el sensor infrarrojo
Serial pc(USBTX, USBRX);
DigitalOut led2_G(LED2);
DigitalOut led2_R(LED3);
DigitalOut led2_B(LED1);
int header =0; //tiempo de cabecera pulso abajo
const int head_H = 3550*1.2; //+20% medida con osciloscopio en microsegundos
const int head_L = 3550*0.8;//-20%  medida con osciloscopio
int i=0;
int n=0;
const int T_alto=1200;//ponga su tiempo de la prueba
const int T_bajo=333;//ponga su tiempo de la prueba
const int num_bits = 48;//ponga su numero de bits
int arreglo[num_bits];
int num[num_bits];//cadena para almacenar todos los tiempos que conforman los bits de datos
int dato; // tiempo de cada dato que se lee
int boton1[num_bits]; //Datos del control tecla 1
int boton2[num_bits]; //Datos del control tecla 2
int boton3[num_bits]; //Datos del control tecla 3
 
void conf_botones(void){
boton1[0]=0; boton1[1]=1; boton1[2]=0; boton1[3]=0; boton1[4]=0; boton1[5]=0; boton1[6]=0; boton1[7]=0; boton1[8]=0;
boton1[9]=0; boton1[10]=0; boton1[11]=0; boton1[12]=0; boton1[13]=1; boton1[14]=0; boton1[15]=0; boton1[16]=0; boton1[17]=0;
boton1[18]=0; boton1[19]=0; boton1[20]=0; boton1[21]=1; boton1[22]=0; boton1[23]=1; boton1[24]=0; boton1[25]=0; boton1[26]=1;
boton1[27]=1; boton1[28]=1; boton1[29]=0; boton1[30]=0; boton1[31]=0; boton1[32]=0; boton1[33]=0; boton1[34]=0; boton1[35]=0;
boton1[36]=1; boton1[37]=0; boton1[38]=0; boton1[39]=0; boton1[40]=0; boton1[41]=0; boton1[42]=1; boton1[43]=1; boton1[44]=0;
boton1[45]=1; boton1[46]=0; boton1[47]=1;

boton2[0]=0; boton2[1]=1; boton2[2]=0; boton2[3]=0; boton2[4]=0; boton2[5]=0; boton2[6]=0; boton2[7]=0; boton2[8]=0;
boton2[9]=0; boton2[10]=0; boton2[11]=0; boton2[12]=0; boton2[13]=1; boton2[14]=0; boton2[15]=0; boton2[16]=0; boton2[17]=0;
boton2[18]=0; boton2[19]=0; boton2[20]=0; boton2[21]=1; boton2[22]=0; boton2[23]=1; boton2[24]=0; boton2[25]=0; boton2[26]=1;
boton2[27]=1; boton2[28]=1; boton2[29]=0; boton2[30]=0; boton2[31]=0; boton2[32]=1; boton2[33]=0; boton2[34]=0; boton2[35]=0;
boton2[36]=1; boton2[37]=0; boton2[38]=0; boton2[39]=0; boton2[40]=1; boton2[41]=0; boton2[42]=1; boton2[43]=1; boton2[44]=0;
boton2[45]=1; boton2[46]=0; boton2[47]=1; 

boton3[0]=0; boton3[1]=1; boton3[2]=0; boton3[3]=0; boton3[4]=0; boton3[5]=0; boton3[6]=0; boton3[7]=0; boton3[8]=0;
boton3[9]=0; boton3[10]=0; boton3[11]=0; boton3[12]=0; boton3[13]=1; boton3[14]=0; boton3[15]=0; boton3[16]=0; boton3[17]=0;
boton3[18]=0; boton3[19]=0; boton3[20]=0; boton3[21]=1; boton3[22]=0; boton3[23]=1; boton3[24]=0; boton3[25]=0; boton3[26]=1;
boton3[27]=1; boton3[28]=1; boton3[29]=0; boton3[30]=0; boton3[31]=0; boton3[32]=0; boton3[33]=1; boton3[34]=0; boton3[35]=0;
boton3[36]=1; boton3[37]=0; boton3[38]=0; boton3[39]=0; boton3[40]=0; boton3[41]=1; boton3[42]=1; boton3[43]=1; boton3[44]=0;
boton3[45]=1; boton3[46]=0; boton3[47]=1;
} 

int main(){
conf_botones();
      led2_B=1;
      led2_G=1;
      led2_R=1;
     
while(1){
ini1: header=0;
      header = irda.read_low_us();    //funcion para leer un pulso de caida o bajo
      if (header > head_L && header < head_H) goto seguir;//verificar que este en la tolerancia +-20%
      else goto ini1;
      
seguir:
       //leo los datos de la trama y se meten a un arreglo
      wait_us(1650/2);
      for(i=0;i<(num_bits);++i){ // POR OSCILOSCOPIO se determina que llegan (num_bits),datos
      dato = irda.read_high_us(); //leer un bit de datos que es pulso arriba en este control
      num[i]=dato;
      wait_us(550/2);   
      }
      wait(0.5); //espero un poquito antes de leer todo el arreglo y ponerlo en pantalla 
      pc.printf(",%d",header);
      for(i=0;i<(num_bits);++i){  
      pc.printf(",%d",num[i]);
      }
      wait(0.1);  //espero e imprimo en binario 
      pc.printf("\n\n");
      for(i=0;i<(num_bits);++i){  
      if(num[i] > ((T_alto+T_bajo)/2)){ 
      arreglo[i]=1;
      pc.printf("%d",arreglo[i]);
      }
      else{
      arreglo[i]=0; 
      pc.printf("%d",arreglo[i]);
      }
      }
  
  for(i=0;i<(num_bits);++i){  
      if(arreglo[i]==boton1[i]){ 
      n++;
      continue;
      }
      else{
      n=0;
      break;
      }
      } 
      pc.printf("\n %d",n);
      if(n==48){
      n=0;
      led2_R=!led2_R;
      goto ini1;
      }
         
  for(i=0;i<(num_bits);++i){  
      if(arreglo[i]==boton2[i]){ 
      n++;
      continue;
      }
      else{
      n=0;
      break;
      }
      } 
      pc.printf("\n %d",n);
      if(n==48){
      n=0;
      led2_G=!led2_G;
      goto ini1;
      } 
 for(i=0;i<(num_bits);++i){  
      if(arreglo[i]==boton3[i]){ 
      n++;
      continue;
      }
      else{
      n=0;
      break;
      }
      } 
      pc.printf("\n %d",n);
      if(n==48){
      n=0;
      led2_B=!led2_B;
      goto ini1;
      }
   }
 }