/**
 * @file   main.cpp
 * @brief  Abstract
 * @copyright (c) Salem TANG
 */
// -----------------------------------------------------------------------------
//  note
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
//  include files
// -----------------------------------------------------------------------------
#include "main.h"
#ifdef SLCD_BLINKING_TEST
#include "SLCD.h"
#include "MAG3110.h"
#include "MMA8451Q.h"
#include "TSISensor.h"
#endif  // SLCD_BLINKING_TEST

// -----------------------------------------------------------------------------
//  general define
// -----------------------------------------------------------------------------
#ifdef SLCD_BLINKING_TEST
#define LED_ON  0
#define LED_OFF 1
#define PRESS_ON  0
#define PRESS_OFF 1
#define MMA8451_I2C_ADDRESS (0x1d<<1)
#endif  // SLCD_BLINKING_TEST

// -----------------------------------------------------------------------------
//  struct define
// -----------------------------------------------------------------------------
#ifdef SLCD_BLINKING_TEST
struct KL46_SENSOR_DATA {
    int   sw1State;
    int   sw3State;
    float accValX;
    float accValY;
    float accValZ;
    float slider;
    float light;
    int   magValX;
    int   magValY;
    int   magValZ;
} sensorData;
#endif  // SLCD_BLINKING_TEST

// -----------------------------------------------------------------------------
//  external function
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
//  function prototype
// -----------------------------------------------------------------------------
#if (defined SLCD_BLINKING_TEST)
void initializeSetting (void);
void SLCD_blinking_msg_wait (char *slcd_msg1, char *slcd_msg2);
#endif  // SLCD_BLINKING_TEST

// -----------------------------------------------------------------------------
//  external variable
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
//  global variable
// -----------------------------------------------------------------------------
#if (defined SLCD_BLINKING_TEST)
PwmOut greenled_PO(LED1);
PwmOut redled_PO(LED2);
DigitalIn switchinput1_DI(SW1);
DigitalIn switchinput3_DI(SW3);
DigitalOut greenled_DO(LED1);
DigitalOut redled_DO(LED2);
InterruptIn switchinput1_INT(SW1);
InterruptIn switchinput3_INT(SW3);
SLCD slcd;
Timer scroll;
AnalogIn  light(PTE22);  // analog-light input
TSISensor slider;  // Capacitive Touch Slider
MAG3110 mag(PTE25, PTE24);  // Magnetometer
MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
Serial usb_osda(USBTX, USBRX);  // OpenSDA Terminal
struct tm t;
int i, j, k, lastscroll, display_timer, minute, hour, colon, dp;
char message[60];
char buffer[32];
float defaultdutyfactor = 0.0;
#endif  // SLCD_BLINKING_TEST

// -----------------------------------------------------------------------------
//  function
// -----------------------------------------------------------------------------
// -----------------------------------------------------------------------------
//! @brief  Main Function
//! @param  [in] nil
//! @retval int
// -----------------------------------------------------------------------------
int main (void)
{
#if (defined SLCD_BLINKING_TEST)
    initializeSetting();
#endif  // SLCD_BLINKING_TEST

    while (true) {
#ifdef SLCD_BLINKING_TEST
        // disable all SLCD DPs
        slcd.DP(0, false); slcd.DP(1, false); slcd.DP(2, false);

        // MAIN/Loop/Sensing and Storing data -----------------//
        sensorData.sw1State = switchinput1_DI; sensorData.sw3State = switchinput3_DI;
        sensorData.accValX = acc.getAccX();  // accX[-1..1]->mouse(Lab1)
        sensorData.accValY = acc.getAccY();  // accY[-1..1]->mouse(Lab1)
        sensorData.accValZ = acc.getAccZ();  // accZ[-1..1]->rLED
        sensorData.slider = slider.readPercentage() * 100;
        sensorData.light = light;
        sensorData.magValX = mag.readVal(MAG_OUT_X_MSB);
        sensorData.magValY = mag.readVal(MAG_OUT_Y_MSB);
        sensorData.magValZ = mag.readVal(MAG_OUT_Z_MSB);

        // MAIN/Loop/Processing and Actions -------------------//
        // sensor -> terminal
        if (sensorData.sw1State != PRESS_OFF) {
            greenled_DO = !greenled_DO;  // blinking 
        } greenled_DO = LED_OFF;

        // acc:z-axis 1g min-blinking  // acc:z-axis 1g min-blinking
        redled_PO = abs(sensorData.accValZ);

        if (sensorData.slider) {
            slcd.printf(" %3.0f", sensorData.slider);  // night->light .. 1->0
        } else {
            slcd.printf("%1.3f", sensorData.light);  // left->right .. 0->100%
        }
        wait(0.05);  // wait 50ms
#endif  // SLCD_BLINKING_TEST
    }
}

// -----------------------------------------------------------------------------
//! @brief  Initialize Setting
//! @param  [in] nil
//! @retval nil
// -----------------------------------------------------------------------------
#if (defined SLCD_BLINKING_TEST)
void initializeSetting (void)
{
#if (defined SLCD_BLINKING_TEST)
    switchinput1_DI.mode(PullUp);
    switchinput3_DI.mode(PullUp);
    greenled_DO = LED_ON;  // Green LED ON to indicate running/writing
    redled_PO = LED_OFF;  // Red LED OFF
    redled_PO.period (150);
    
    //---- MAIN/Inits (Wait4SW1) -> Start! --------------------//  
    // wait for Press SW1 - e.g. for HID/CDC/MsensorData Windows install.
    SLCD_blinking_msg_wait("   o","PrES");  // Lab1=Hid; 2=cdc; 3=MsensorData

    //---- MAIN/Inits Interface -------------------------------//
    usb_osda.baud (115200);
    usb_osda.printf ("\n___________________________________\r\n");
    usb_osda.printf ("\nFRDM-KL46Z_Lab\r\n \r\n I am a CDC serial port @OpensensorDataA/mUSB. Baud=115200 \r\n");

    //---- MAIN/Inits Done! (Wait4SW1) -> MANI/Loop -----------//
    greenled_DO = LED_OFF;  // Inits are done
#endif  // SLCD_BLINKING_TEST
}
#endif  // SLCD_BLINKING_TEST

// -----------------------------------------------------------------------------
//! @brief  SLCD Blinking Massage
//! @param  [in] *slcd_msg1 Massage 1
//! @param  [in] *slcd_msg2 Massage 2
//! @retval nil
// -----------------------------------------------------------------------------
#ifdef SLCD_BLINKING_TEST
void SLCD_blinking_msg_wait (char *slcd_msg1, char *slcd_msg2)
{
    char wait4sw1 = 0;  // 500ms blinking
    slcd.CharPosition = 0;
    // wait for Press SW1 - to start mag calibration
    while (switchinput1_DI == PRESS_ON);  // wait for release
    while (switchinput1_DI == PRESS_OFF) {  // wait for press
        if (++wait4sw1 < 150) {  // 300ms
            slcd.printf(slcd_msg1);
        } else {  //200ms
            slcd.printf (slcd_msg2);
            wait (0.002);
            slcd.CharPosition = 0;
        }
    }
    while (switchinput1_DI == PRESS_ON);  // wait for release
}
#endif  // SLCD_BLINKING_TEST
