#include "mbed.h"
 //#include "debug.h"
 
#include "LSM303DLH.h"
#include "AnsiGraphicalConsole.h"
#include "vector.h"
#include "L3GD20.h"
 
#define LSM303_REG_TEMP (0x00) // Temperature Register
#define LSM303_REG_CONF (0x01) // Configuration Register
#define LSM303_ADDR     (0x90) // LSM303 address
 
 
#define USE_LM303
#define USE_L3GD20
DigitalIn mybutton(USER_BUTTON);
I2C ptr_i2c(I2C_SDA, I2C_SCL);
#if defined(USE_L3GD20)
L3GD20    gyro(&ptr_i2c);//(I2C_SDA, I2C_SCL);   
#endif
#if defined(USE_LM303)
LSM303DLH compass(&ptr_i2c);//(I2C_SDA, I2C_SCL);
#endif

DigitalOut myled(LED1);
 
Serial pc(SERIAL_TX, SERIAL_RX);
 
//volatile char TempCelsiusDisplay[] = "+abc.d C";

int main()
{
 
    pc.printf("\n Test Salco \n");
    clearscreen();
    
    /*char data_write[2];
    char data_read[2];*/
    
    /* Configure the Temperature sensor device STLM75:
    - Thermostat mode Interrupt
    - Fault tolerance: 0
    */
    //data_write[0] = LM75_REG_CONF;
   // data_write[1] = 0x02;
   // int status =
    /*if (status != 0) { // Error
        while (1) {
            myled = !myled;
            wait(0.2);
        }
    }*/
    
#if defined(USE_LM303)
  //compass.setOffset(29.50, -0.50, 4.00); // example calibration
  compass.setScale(1.00,1.00,1.00); //1.03, 1.21);    // example calibration
  compass.frequency(100000);
  vector accelerometer,magnetometer;
  float hdg;
  #endif
    
    #if defined(USE_L3GD20)
    vector gyroscope;
    #endif
    char index=0;
    
    while (1) {
        
        
        //hdg = compass.heading();
        //debug.printf("Heading: %.2f\n", hdg);
 
        // Display result
        //pc.printf("Heading: %.2f\n", hdg);
        myled = !myled;
        if(index>=2)
        {
            #if defined(USE_LM303)          
            if(compass.read(accelerometer,magnetometer))
            {
                setText(0,10,"accelerometer: X:%.2f Y:%.2f Z:%.2f\n", accelerometer.x,accelerometer.y,accelerometer.z);
                setText(0,11,"magnetometer:  X:%.4f Y:%.4f Z:%.4f\n", magnetometer.x,magnetometer.y,magnetometer.z);
                
               
                hdg = compass.heading((vector){0,0,-1});
                setText(0,12,"Heading: %.2f\n", hdg);
                //magnetometre {+-20@ 0}== axe nord/sud
                //si X pos coter NORD et si X neg SUD
            }
            else
            {
                pc.printf("Error with I2C com\n");
            }
            #endif
            index=0;
            #if defined(USE_L3GD20)
            if(gyro.read(&gyroscope.x,&gyroscope.y,&gyroscope.z))
            {
                gyro.Convert_to_RadPerSec(&gyroscope.x,&gyroscope.y,&gyroscope.z);
                setText(0,13,"gyroscope:  X:%.2f Y:%.2f Z:%.2f\n", gyroscope.x,gyroscope.y,gyroscope.z);
            }
            else
            {
                pc.printf("Error with I2C com\n");
                
            }
            #endif
        }
                
        wait(.5);
        index++;
        
         if (mybutton == 0) 
         { // Button is pressed
             do{
                clearscreen();
                setText(0,1,"PAUSE\n");
                wait(2);
             }while(mybutton != 0);
             clearscreen();
         }
    }
 
}
 
