/*******************************************************************************
* RenBED PID Motor Control for RenBuggy                                        *
* Copyright (c) 2014 Sally Brown & Liz Lloyd                                   *
*                                                                              *
* Permission is hereby granted, free of charge, to any person obtaining a copy *
* of this software and associated documentation files (the "Software"), to deal*
* in the Software without restriction, including without limitation the rights *
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell    *
* copies of the Software, and to permit persons to whom the Software is        *
* furnished to do so, subject to the following conditions:                     *
*                                                                              *
* The above copyright notice and this permission notice shall be included in   *
* all copies or substantial portions of the Software.                          *
*                                                                              *
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR   *
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,     *
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE  *
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER       *
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,*
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN    *
* THE SOFTWARE.                                                                *
*                                                                              *
*******************************************************************************/

#include "RenBuggy_PID.h"

int main()
{
    //The code defaults to the striped wheel buggy configuration for counts per rev, wheel circumference, axle width
    //pins are motor l, motor r, brake l, brake r, sensor l, sensor r
    //Supply the appropriate pins for the motors, brakes and sensors.
    //i.e. if you left motor is wired to pin p25 then supply p25 as the parameter for the left motor
    //PID_Stripes pid(p25, p10, p8, p7, p9, p21);
    
    
    //No striped wheels - remember to set up the constants
    //i.e. counts per rev, wheel circumference, axle width
    //pins are motor l, motor r, brake l, brake r, sensor l, sensor r
    //PID_Magnet pid(p25, p10, p8, p7, p9, p21);
    PID_Magnet pid(p5, p6, p7, p8, p21, p22);
    pid.SetUpConstants(64, 11.31, 6.4);
    
    pid.Stop();
    pid.Forwards(50);
    pid.Stop();
    pid.Left(90, 13);
    pid.Stop();
    pid.Forwards(20);
    pid.Right(90,20);
    pid.Stop();    
}