/*******************************************************************************
* RenBED PID Motor Control for RenBuggy                                        *
* Copyright (c) 2014 Sally Brown & Liz Lloyd                                   *
*                                                                              *
* Permission is hereby granted, free of charge, to any person obtaining a copy *
* of this software and associated documentation files (the "Software"), to deal*
* in the Software without restriction, including without limitation the rights *
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell    *
* copies of the Software, and to permit persons to whom the Software is        *
* furnished to do so, subject to the following conditions:                     *
*                                                                              *
* The above copyright notice and this permission notice shall be included in   *
* all copies or substantial portions of the Software.                          *
*                                                                              *
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR   *
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,     *
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE  *
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER       *
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,*
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN    *
* THE SOFTWARE.                                                                *
*                                                                              *
* PID_Controller.h                                                             *
*                                                                              *
*******************************************************************************/

#ifndef _PIDCONTROLLER_H
#define _PIDCONTROLLER_H

#include "mbed.h"
#include "PID.h"
#include "PinDetect.h"

#define pi      3.1416
#define RATE    0.001

class PID_Controller
{
    public:    
        void SetUpConstants(int countsPerRev, float wheelCircumference, float axleLength);
        
        void Forwards(int distanceForward);
        void Left(int angleLeft, int radiusLeft);
        void Right(int angleRight, int radiusRight);
        
        void Stop();
        
        void ConfigurePID(float p, float i, float d);
        
        void countL();
        void countR();
        
    protected:
    
        PID_Controller(PinName motorL, PinName motorR, PinName brakeL, PinName brakeR);
        virtual void setUpControllers();
        PID getLeftController() {return m_controllerL;}
        PID getRightController() {return m_controllerR;}
                       
    private:
    
        void doSomePID();
        void PIDLeft();
        void PIDRight();
        
        PID     m_controllerL;  //Kc, Ti, Td, interval
        PID     m_controllerR;
               
        PwmOut  m_motorL;
        PwmOut  m_motorR;
        
        DigitalOut m_brakeL;
        DigitalOut m_brakeR;

        Ticker  m_rate;
        
        int     m_countsPerRev;
        float   m_wheelCircumference;
        float   m_axleLength;

        int     m_stripesL;
        int     m_stripesR;
        
        bool    m_turnLeft;
        bool    m_turnRight;
        
        float   m_fProportionLeft;
        float   m_fProportionRight;
};

class PID_Stripes : public PID_Controller
{
    public:
        PID_Stripes(PinName motorL, PinName motorR, PinName brakeL, PinName brakeR, PinName sensorL, PinName sensorR);
    
    private:        
        PinDetect   m_senseL;     //Left encoder. Pin detect type is the debouncing.
        PinDetect   m_senseR; 
};

class PID_Magnet : public PID_Controller
{
    public:
        PID_Magnet(PinName motorL, PinName motorR, PinName brakeL, PinName brakeR, PinName sensorL, PinName sensorR);
    
    private:        
        InterruptIn   m_senseL;     //Left encoder. 
        InterruptIn   m_senseR; 
};

#endif    // _PIDCONTROLLER_H