/*******************************************************************************
* This program demonstrates how to drive the seven segment display *
* *
* Jon Fuge *
* V1.0 13/12/2013 First issue of code *
*******************************************************************************/
#include "mbed.h"
#include "SevenSegLed.h"

// Lets define some "macros" to make the code easier to read
#define mUnits D_7seg[1]    // "mUnits" will be substiuted for "D_7seg[1]"
#define mTens D_7seg[0]     // "mTens" will be substiuted for "D_7seg[0]"
#define mDot D_dot[1]       // "mDot" will be substiuted for "D_dot[1]"

void attimeout(); //declare prototype for timeout handler.
//configure sevensegled pin connection mapping.
//
// common type (0:anode common 1:cathode common)
// | display mode (0:smooth 1:hard)
// | | segA segB segC segD segE segF segG segP com1 com2
SevenSegLed segmentled(0, 0, P1_23, P1_28, P0_16, P1_31, P1_13, P1_16, P1_19, P0_23, p21, P1_25);

//Define two arrays to house the data to be outputted. D_7seg can contain digits 0‐F and D_dot 0‐1.
//
// 0 1 //0 = leftmost digit, 1 = rightmost digit
// | |
uint8_t D_7seg[2] = {0, 0}; // number (0x00:"0", ... , 0x09:"9", 0x0A:"A", ... , 0x0F:"F", other:" ")
uint8_t D_dot[2] = {0, 0}; // dotpoint. (0:off 1:on)
Ticker timeout; //Create an instance of class Ticker called timeout.

int main()
{
    timeout.attach_us(&attimeout, 500000); // Set up interrupt to call attimeout() every half a second.
    for(;;)
    {
        segmentled.SevenSegLed_main(D_7seg, D_dot); // Keep the displays multiplexed.
    }
}

void attimeout() //Timer interrupt routine.
{
    mDot = 1 - mDot;
    if (mDot == 1) 
    {
        mUnits++; // This means the same as D_7seg[0] = D_7seg[0] + 1; Increment "units"
        
        if (mUnits > 9)
        { // "units" digit should be in the range 0 ‐> 9
            mUnits = 0; // Reset the "units" to 0
            mTens++; // Increment "tens" digit
            
            if (mTens > 9)
            { // "tens" digit should be in the range 0 ‐> 9
                mTens = 0; // Reset the "tens" to 0
            }
        }
    }
}