/*******************************************************************************
* This program demonstrates how to read a switch and toggle a LED.             *
* Connect LED and resistor between to DIP36 (P0_21) and DIP1 (0V).             *
* Connect switch between DIP5 (P0_9) and DIP1 (0V).                            *
*                                                                              *
* Jon Fuge                                                                     *
* V1.0 12/11/2013 First issue of code                                          *
*******************************************************************************/

#include "mbed.h" // has prototypes for DigitalIn and DigitalOut

DigitalIn  mybutton(P0_9); // mybutton reads bit  9 of port 0 (DIP5).
DigitalOut myled(P0_21);   // myled controls bit 21 of port 0 (DIP36).

int main() {
   mybutton.mode(PullUp); // Configure pin to be a pull‐up input
   for(;;) { //Create infinite loop to keep program running.
      if (mybutton == 0) { // if mybutton = 0, then it has been pressed
         myled = !myled; // myled will now become !myled (! means NOT).
         wait(0.1); // Wait for 0.1 seconds to "debounce" the switch.
         while (mybutton == 0) {} // Wait for my button to be released.
      } // End of if (mybutton == 0)
   } // End of for(;;)
} // end of int main()
