#ifndef PULSE_DECODER_H
#define PULSE_DECODER_H

/// @file pulse_decoder.h This library provides a simple PWM decoder class.
///
/// The approach is based on installing two interrupt routines for the rising and
/// falling edges of an input pin and measuring the time between the two events.
///
/// Example:
/// @code
/// #include "mbed.h"
/// void main()
/// {
///     pulse_decoder pulse(D7);
///
///     while(true) {
///         printf("Pulse high = %5d low = %5d (us) Period = %5d\n", 
///           pulse.get_high_period(), pulse.get_low_period(), 
///           pulse.get_high_period() + pulse.get_low_period());  
///         wait(.2);
///     }    
/// }
/// @endcode

class pulse_decoder {
public:
    ///Creates a pulse_decoder
    ///@param[in] pin the input pin on the microcontroller
    pulse_decoder(PinName pin);
    
    ///Get the period of time that the pulse was in high state
    ///@return the period in us
    int get_high_period() const
    {
        return high_period;
    }

    ///Get the period of time that the pulse was in low state
    ///@return the period in us        
    int get_low_period() const
    {
        return low_period;
    }
    
private:
    InterruptIn interrupt;
    Timer high_timer;
    Timer low_timer;
    volatile int high_period;
    volatile int low_period;
    
    void rising_edge();
    void falling_edge();
}; 

#endif //PULSE_DECODER_H