#include "mbed.h"
#include "pulse_decoder.h"

pulse_decoder::pulse_decoder(PinName pin)
    : interrupt(pin), high_period(0), low_period(false)
{
    interrupt.rise(this, &pulse_decoder::rising_edge);
    interrupt.fall(this, &pulse_decoder::falling_edge);
}

void pulse_decoder::rising_edge()
{
    high_timer.start();
    low_timer.stop();
    
    low_period = low_timer.read_us();  
    low_timer.reset();  
}

void pulse_decoder::falling_edge()
{
    high_timer.stop();
    low_timer.start();
    
    high_period = high_timer.read_us();
    high_timer.reset();
}
