#include "mbed.h"
#include "SakuraIO.h"
#include "debug.h"


void SakuraIO_SPI::begin(){
  dbg("CS=0\r\n");
  _cs = 0;
}

void SakuraIO_SPI::end(){
  dbg("CS=1\r\n");
  _cs = 1;
  wait_ms(20);
}

void SakuraIO_SPI::sendByte(uint8_t data){
  wait_ms(20);
  dbg("Send=%02x\r\n", data);
  _spi.write(data);
}


uint8_t SakuraIO_SPI::receiveByte(bool stop){
  return receiveByte();
}

uint8_t SakuraIO_SPI::receiveByte(){
  uint8_t ret;
  wait_ms(20);
  ret = _spi.write(0);
  dbg("Recv=%d\r\n", ret);
  return ret;
}

SakuraIO_SPI::SakuraIO_SPI(SPI &spi, PinName cs) : _spi(spi), _cs(cs) {
    _cs = 1;
}

SakuraIO_SPI::SakuraIO_SPI(PinName mosi, PinName miso, PinName sck, PinName cs) : _spi(mosi, miso, sck), _cs(cs) {
    _cs = 1;
}
