/* SAKURA Internet IoT Communication Module Library for mbed
 *
 * Copyright (c) SAKURA Internet Inc.
 *   The MIT License (MIT)
 *   https://github.com/sakura-internet/SakuraIOArduino
 *
 * https://iot.sakura.ad.jp/
 *
 * Porting to mbed by sakurafan. 2016
 */

#ifndef _SAKURAIO_H_
#define _SAKURAIO_H_

#include "mbed.h"
#include "commands.h"

class SakuraIO
{
protected:
  virtual void begin(){}
  virtual void end(){}

  virtual void sendByte(uint8_t data){}
  //virtual void finishSending(){}

  virtual uint8_t startReceive(uint8_t length){return length;};
  virtual uint8_t receiveByte(){return 0x00;}
  virtual uint8_t receiveByte(bool stop){return 0x00;}
  //virtual void finishReceiving(){}

  uint8_t executeCommand(uint8_t cmd,uint8_t requestLength, uint8_t *request, uint8_t *responseLength, uint8_t *response);

  uint8_t enqueueTxRaw(uint8_t ch, uint8_t type, uint8_t length, uint8_t *data, uint64_t offset);

public:
  uint8_t getConnectionStatus();
  uint8_t getSignalQuarity();
  uint64_t getUnixtime();
  uint8_t echoback(uint8_t length, uint8_t *data, uint8_t *response);
  uint16_t getADC(uint8_t channel);
  uint8_t enqueueTx(uint8_t ch, int32_t value, uint64_t offset);
  uint8_t enqueueTx(uint8_t ch, uint32_t value, uint64_t offset);
  uint8_t enqueueTx(uint8_t ch, int64_t value, uint64_t offset);
  uint8_t enqueueTx(uint8_t ch, uint64_t value, uint64_t offset);
  uint8_t enqueueTx(uint8_t ch, float value, uint64_t offset);
  uint8_t enqueueTx(uint8_t ch, double value, uint64_t offset);
  uint8_t enqueueTx(uint8_t ch, uint8_t value[8], uint64_t offset);
  uint8_t enqueueTx(uint8_t ch, int32_t value);
  uint8_t enqueueTx(uint8_t ch, uint32_t value);
  uint8_t enqueueTx(uint8_t ch, int64_t value);
  uint8_t enqueueTx(uint8_t ch, uint64_t value);
  uint8_t enqueueTx(uint8_t ch, float value);
  uint8_t enqueueTx(uint8_t ch, double value);
  uint8_t enqueueTx(uint8_t ch, uint8_t value[8]);
  uint8_t getTxQueueLength(uint8_t *available, uint8_t *queued);
  uint8_t clearTx();
  uint8_t getTxStatus(uint8_t *queue, uint8_t *immediate);
  uint8_t send();
  uint8_t dequeueRx(uint8_t *ch, uint8_t *type, uint8_t *value, int64_t *offset);
  uint8_t peekRx(uint8_t *ch, uint8_t *type, uint8_t *value, int64_t *offset);
  uint8_t getRxQueueLength(uint8_t *available, uint8_t *queued);
  uint8_t clearRx();
  uint16_t getProductID();
  uint8_t getUniqueID(char *data);
  uint8_t getFirmwareVersion(char *data);
  uint8_t unlock();
  uint8_t updateFirmware();
  uint8_t getFirmwareUpdateStatus();
  uint8_t reset();
};

class SakuraIO_SPI : public SakuraIO
{
protected:
  SPI _spi;
  DigitalOut _cs;

  virtual void begin();
  virtual void end();
  virtual void sendByte(uint8_t data);
  virtual uint8_t receiveByte(bool stop);
  virtual uint8_t receiveByte();
public:
  SakuraIO_SPI(SPI &spi, PinName cs);
  SakuraIO_SPI(PinName mosi, PinName miso, PinName sck, PinName cs);
};

class SakuraIO_I2C : public SakuraIO
{
protected:
  I2C _i2c;
  int _length;

  virtual void begin();
  virtual void end();
  virtual void sendByte(uint8_t data);
  virtual uint8_t startReceive(uint8_t length);
  virtual uint8_t receiveByte(bool stop);
  virtual uint8_t receiveByte();
  uint8_t mode;
public:
  SakuraIO_I2C (I2C &i2c);
  SakuraIO_I2C (PinName sda, PinName scl);
};

#endif // _SAKURAIO_H_
