/* SAKURA Internet IoT Alpha Communication Module
 *
 * Copyright (c) SAKURA Internet Inc.
 *   The MIT License (MIT)
 *   https://github.com/sakura-internet/SakuraAlphaArduino
 *
 * https://iot.sakura.ad.jp/
 *
 * Porting to mbed by sakurafan. 2016
 */

#include "mbed.h"
#include "SakuraAlpha.h"

#define BUF_LEN 16

SakuraAlphaSPI sakura(p5, p6, p7, p8); // mosi, miso, sclk, cs
/*
SPI spi(p5, p6, p7); // mosi, miso, sclk
SakuraAlphaSPI sakura(spi, p8); // spi, cs
*/
Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

int main () {
    uint32_t cnt = 0;
    uint8_t updated[BUF_LEN];

    pc.baud(115200);
    pc.printf("Waiting to come online...\r\n");

    for(;;){
        if( sakura.getNetworkStatus() == 1 ) break;
        myled = !myled;
        wait_ms(1000);
    }
    myled = 1;

    for (;;) {
        cnt++;
        pc.printf("%d\r\n", cnt);
        sakura.writeChannel(0,cnt);
        sakura.writeChannel(1,cnt);
        sakura.writeChannel(2,cnt);
        wait_ms(250);

        int num_updated = sakura.getUpdatedChannels(updated, BUF_LEN);
        pc.printf("%d updated channels: ", num_updated);
        for (int i = 0; i < min(num_updated,BUF_LEN); i++) {
            pc.printf(" %d", updated[i]);
        }
        pc.printf("\r\n");

        char type=0;
        uint8_t value[8]={0};

        sakura.readChannel(0, &type, value);

        for (int i = 0; i < 8; i++) {
            pc.printf(" %x", value[i]);
        }

        pc.printf(" type: %d\r\n", type);
        wait_ms(250);

        pc.printf("Tx[0] status: %d\r\n", sakura.getTxChannelStatus(0));

        sakura.transmit(TRANSMIT_ONCE);
        wait_ms(250);

        num_updated = sakura.getUntransmittedChannels(updated, BUF_LEN);
        pc.printf("%d untransmitted channels: ", num_updated);
        for (int i = 0; i < min(num_updated,BUF_LEN); i++) {
            pc.printf(" %d", updated[i]);
        }
        pc.printf("\r\n");
        wait_ms(1000);

        pc.printf("\r\n");
    }
}
