#include "mbed.h"
#include "rtos.h"

void write_to_master(char);                    //function to write data to master
Thread * ptr_t_i2c;
I2CSlave slave(D14,D15);                       //configuring pins p27, p28 as I2Cslave
Serial pc (USBTX,USBRX);
InterruptIn interrupt(D9);
InterruptIn master_reset(D11);
DigitalOut data_ready(D10);
int i2c_status=0;                                 //read/write mode for i2c 0 : write2slave, 1 : write2master
int reset=0;
int temp;


typedef struct
{
    char data;          // To avoid dynamic memory allocation
    int length;
}i2c_data;

Mail<i2c_data,16> i2c_data_receive;
Mail<i2c_data,16> i2c_data_send;
         

int receive_status =0;
void FUNC_I2C_WRITE2CDMS(char *data, int length=1)
{
       int slave_status = 1;
 //  printf("\nData is %c\n\r",*data);  
         
    slave.address(0x20);
    unsigned char* add_reg = (unsigned char*)0x40067000;
    unsigned char* data_reg = (unsigned char*)0x40067004;
    unsigned char* status_reg = (unsigned char*)0x40067003;
    unsigned char* c1_reg = (unsigned char*)0x40067002;
    unsigned char* c2_reg = (unsigned char*)0x40067005;  
    unsigned char* freq_reg = (unsigned char*)0x40067001;     
    while(slave_status && interrupt ==1)
    {        
          //wait(2);
            receive_status = slave.receive();
            
            if( receive_status==1)
            {
               // printf("\nslave receive b4: \n");
                slave_status=slave.write(data,length);
               // printf("\nData sent to CDMS is %c\n\r",*data);
              // printf("\n\r write"); 
                //printf("\nslave receive after: %d \n",slave.receive());
                
            }
            else if( receive_status==3 ||  receive_status==2)
            {
                slave_status=slave.read(data,length);
               // printf("\n\r read");
            }
            //printf("\n \r done while loop %d \n",slave.receive());
            //printf("\n\r ahoy drhghhhhhhhhhhh\n");
             printf("\n\r %d %d %d %d %d \n",*data_reg,*status_reg,*c1_reg,*c2_reg,*freq_reg);
            
    }
            printf("\ndone\n\r");

}

void T_I2C_BAE(void const * args)
{
    char data_send,data_receive;
    while(1)
    {
        Thread::signal_wait(0x1);
        //i2c_status = temp;
        //wait(0.5);
        printf("\n entered thread\n\r");
        if(i2c_status == 0 && reset !=1)
        {
            
            FUNC_I2C_WRITE2CDMS(&data_receive);
            i2c_data * i2c_data_r = i2c_data_receive.alloc();
            i2c_data_r->data = data_receive;
            i2c_data_r->length = 1;
            i2c_data_receive.put(i2c_data_r);
            printf("\n Data received from CDMS is %c\n\r",data_receive);
            i2c_data_receive.free(i2c_data_r);                              // This has to be done from a differen thread
            
        }
        else if(i2c_status ==1 && reset !=1)
        {
            osEvent evt = i2c_data_send.get();
            if (evt.status == osEventMail) 
            {
                i2c_data *i2c_data_s = (i2c_data*)evt.value.p;
                data_send = i2c_data_s -> data;
                //printf("\n1.Data is %c\n\r",data_send);
                FUNC_I2C_WRITE2CDMS(&data_send);
                printf("\nData sent to CDMS is %c\n\r",data_send);
                i2c_data_send.free(i2c_data_s);
                i2c_status = 0;
                //temp = i2c_status;
            }
        }  
          
          data_ready=0; 
    }
}
        
void FUNC_INT()
{
   reset = 0;
   ptr_t_i2c->signal_set(0x1);
     
}

void FUNC_RESET()
{
    reset = 1;
}

void ir2master()
{
        
        char data='a';
        //data_ready=0;
        data = pc.getc();
        
        reset =0;
        i2c_status=1;
        i2c_data * i2c_data_s = i2c_data_send.alloc();
        i2c_data_s->data = data;
        i2c_data_s->length = 1;
        i2c_data_send.put(i2c_data_s); 
        data_ready=1;
        //temp = i2c_status;
}
      
   


int main()
{   
    printf("\n slave started\n\r");
    
    ptr_t_i2c = new Thread(T_I2C_BAE);
    master_reset.fall(&FUNC_RESET);
    interrupt.rise(&FUNC_INT);
    while(1)
    {
      ir2master(); 
                
    }
     
}




