#include "mbed.h"
#include "rtos.h"

void write_to_master(char);                    //function to write data to master
Thread * ptr_t_i2c;
I2CSlave slave(D14,D15);                       //configuring pins p27, p28 as I2Cslave
Serial pc (USBTX,USBRX);
InterruptIn interrupt(D9);
DigitalOut data_ready(D10);
int i2c_status=0;    
                           //read/write mode for i2c 0 : write2slave, 1 : write2master

typedef struct
{
    char data;          // To avoid dynamic memory allocation
    int length;
}i2c_data;

Mail<i2c_data,16> i2c_data_receive;
Mail<i2c_data,16> i2c_data_send;

void FUNC_I2C_WRITE2CDMS(char *data, int length=1)
{
       
    int slave_status = 1;
    while(slave_status)
    {                 
            slave.address(0x20);
            if(slave.receive()==1)
            {
                slave_status=slave.write(data,length);
               // printf("\n In the while loop\n");
                
                /*if(!slave_status)
                {
                        printf("slave wrote %c to master\n\r",*data);
              
                }*/
                
            }
            else
                if(slave.receive()==3 || slave.receive()==2)
                {
                     //i2c_data *i2c_data_r = i2c_data_receive.alloc();
                     slave_status=slave.read(data,length);
                     /*if(!slave_status)
                     {
                         printf("1 read %c from master\n\r",*data);
                     }*/
                }
            //slave.stop();
    }
            printf("\n 2 done\n\r");

}

void T_I2C_BAE(void const * args)
{
    char data_send,data_receive;
    //data_send = 'a';
    while(1)
    {
        Thread::signal_wait(0x1);
        
        printf("\n interrupt detected \n\r");
        if(i2c_status == 0)
        {
            
            FUNC_I2C_WRITE2CDMS(&data_receive);
            printf("\n entered i2c =0\n\r");
            //printf("\n Data received from CDMS is %c\n",data_receive);
            i2c_data * i2c_data_r = i2c_data_receive.alloc();
            i2c_data_r->data = data_receive;
            i2c_data_r->length = 1;
            i2c_data_receive.put(i2c_data_r);
        }
        else if(i2c_status ==1 )
        {
            osEvent evt = i2c_data_send.get();
            if (evt.status == osEventMail) 
            {
                i2c_data *i2c_data_s = (i2c_data*)evt.value.p;
                //printf("\nData read from CDMS is %c\n",i2c_data_r->data);
                data_send = i2c_data_s -> data;
                FUNC_I2C_WRITE2CDMS(&data_send);
                printf("\nData sent to CDMS is %c\n\r",data_send);
                i2c_data_send.free(i2c_data_s);
                i2c_status = 0;
                //delete i2c_data_r;
            }
        }   
    }
}
        
void FUNC_INT()
{
  // char * data = new char;
   //*data = 'a';
   ptr_t_i2c->signal_set(0x1);
   //delete data;
}
   


void main()
{
    printf("\nStarted slave... waiting for master\n\r");
    ptr_t_i2c = new Thread(T_I2C_BAE);
    char data='a';
    interrupt.rise(&FUNC_INT);
    while(1)
    {
        //*(data_send)=pc.getc();
        
        //FUNC_I2C_WRITE2CDMS(&data,1);
        //printf("\n The data send or received by slave is %c\n",data);
        //(data)++;
        //wait(1);
        //Remove the comments for receiving data
        /* osEvent evt = i2c_data_receive.get();
         if (evt.status == osEventMail) 
         {
            i2c_data *i2c_data_r = (i2c_data*)evt.value.p;
            printf("\nData read from CDMS is %c\n",i2c_data_r->data);
            
            i2c_data_receive.free(i2c_data_r);
            //delete i2c_data_r;
        }*/
        //put in comments for receiving data
        
        data_ready=0;
        data = pc.getc();
        i2c_data * i2c_data_s = i2c_data_send.alloc();
        i2c_data_s->data = data;
        i2c_data_s->length = 1;
        i2c_data_send.put(i2c_data_s);
        i2c_status=1;
        data_ready=1;
                
    }
}