#include "mbed.h"

#define interrupt D9
                    

I2CSlave slave(D14,D15);                       
Serial pc(USBTX,USBRX);
InterruptIn m2s_interrupt(interrupt);

void execute_command(char* cmd);

void read_command()
{
    printf("\nEntered slave \n\r");
    char *command = new char;   
    slave.address(0x20);
    int slave_status =1;
    slave.stop();
    while(slave.receive()!=3);
    while(slave_status)
        slave_status=slave.read(command,1);
    printf("\nread %c from master\n\r",*command);
    execute_command(command);   //assumed command is very important
    printf("\n done \n \r");
    delete command;
}

void execute_command(char* cmd)
{
    switch(*cmd)
    {
        case '0':printf("\n command 0 executed \n\r");
        break;
        case '1':printf("\n command 1 executed \n\r");
        break;
        case '2':printf("\n command 2 executed \n\r");
        break;
        case '3':printf("\n command 3 executed \n\r");
        break;
        case '4':printf("\n command 4 executed \n\r");
        break;
    }
}
    

                   
int main()
{   
    printf("\nwaiting for command from master\n\r");
    m2s_interrupt.rise(&read_command);
    while(1)
    {
        ;
    }
}