#include "mbed.h"
#include "rtos.h"
#include "HK.h"
#include "slave.h"
#include "beacon.h"
#include "ACS.h"
#include "fault.h"
#include "slave.h"
#include "mnm.h"

Serial pc(USBTX, USBRX);

//InterruptIn interrupt( PIN97);                                      //I2c interrupt from CDMS
//DigitalOut data_ready(PIN90);                                     //Sends interrupt to CDMS
InterruptIn interrupt(D9);                                      //I2c interrupt from CDMS
DigitalOut data_ready(D10);   

Timer t;                                                        //To know the time of execution each thread
Timer t1;                                                       //To know the time of entering  of each thread
Timer t2;                                                       //To check the time sync in i2c communication
Timer t3;                                                       //To know the time taken by i2c read/write function
Timer i1;
Timer i2;
Timeout bea_timeout ;                                           // timeout used to revive beacon 10 min after it is switched off
/*****************************************************************Threads USed***********************************************************************************/
Thread *ptr_t_hk_acq;              //pointer:::::::::to read state of one thread from another
Thread *ptr_t_acs;
Thread *ptr_t_bea;
Thread *ptr_t_i2c;
Thread *ptr_t_wdt;

/****************************************************************FUNC_HEADER**********************************************************************************/
void FUNC_I2C_INT();
void FUNC_I2C_IR2CDMS();
void FUNC_I2C_TC_EXECUTE (char command);
void FUNC_BEA_TIMEOUT();

/****************************************************************configuring I2c*********************************************************************************/
I2CSlave slave(PIN1,PIN2);                                        //configuring pins p27, p28 as I2Cslave
//I2CSlave slave (D14,D15);
int i2c_status=0;                                               //read or write mode for i2c 0: write2slave 1: write2master
typedef struct                                                  //structure of i2c data 
{
    char data[25];                          
    int length;
}i2c_data;


//Mail<i2c_data,16> i2c_data_receive;
Mail<i2c_data,16> i2c_data_send;

//--------------------------------------------------------------------------------------------------------------------------------------------------
//TASK 2 : HK
//--------------------------------------------------------------------------------------------------------------------------------------------------

char hk_data[25];
extern SensorDataQuantised SensorQuantised;      /// SensorDataQuantised: struct   instance :SensorQuantised
void T_HK_ACQ(void const *args)
{
    
    while(1)
    {
        Thread::signal_wait(0x2);                                  // 0x2 random should be same in master n slave 
        SensorQuantised.power_mode='3';                          //default power mode(dummy)
        printf("\n\rTHIS IS HK    %f\n\r",t1.read());
        t.start();
        FUNC_HK_FAULTS();                                        // !Actual fault management is not implemented : polling
        FUNC_HK_POWER(SensorQuantised.power_mode);               // !The power mode algorithm is yet to be obtained  // status of power modde will decide actions
        FUNC_HK_MAIN();                                          //Collecting HK data for ADC n 
       //FUNC_I2C_IR2CDMS();                                      //sending HK data to CDMS
        t.stop();
        printf("The time to execute hk_acq is %f seconds\n\r",t.read());
        t.reset();
    }
}

//---------------------------------------------------------------------------------------------------------------------------------------
//TASK 1 : ACS
//---------------------------------------------------------------------------------------------------------------------------------------

int acs_pflag = 1;                                                               // power mode decision flag for ACS
void T_ACS(void const *args)
{
    float mag_field[3]; // rm3000
    float omega[3]; //mpu3300
    float *mnm_data;                        // 
    float mag_field1[3];
    float omega1[3];
    float tauc1[3];
    float moment[3];
    while(1)
    {
        Thread::signal_wait(0x1);
        printf("\n\rEntered ACS   %f\n",t1.read());
        t.start();
        FUNC_ACS_MAG_EXEC(mag_field); ///rm3000
        //printf("\n\r check");
         for(int i=0; i<3; i++) 
            {
            printf("%f\t",mag_field[i]);
            }                         
        FUNC_ACS_EXEC_GYR(omega);    // mpu3300
        acs_pflag =1;                       //to be removed later 
        omega[0] = 1.0;
        omega[1] = 1.0;
        omega[2] = 1.0;
        
       
       
       mnm_data=EXECUTE_PNI(); //the angular velocity is stored in the first 3 values and magnetic field values in next 3
        printf("\n\rmnm gyro values\n"); //printing the angular velocity and magnetic field values
        for(int i=0; i<3; i++) 
        {
            printf("%f\t",mnm_data[i]);
        }
        printf("\n\r mnm mag values\n");
        for(int i=3; i<6; i++) 
        {
            printf("%f\t",mnm_data[i]);
        }
        for(int i = 0 ; i<3;i++)
        {
            omega1[i] = mnm_data[i];
        }
        for( int i = 3;i<6;i++)
        {
            mag_field1[i-3] = mnm_data[i];
        }
        
        if(acs_pflag == 1)            
        {
           
            FUNC_ACS_CNTRLALGO(mag_field,omega,tauc1);
            printf("\n\r control algo values ");
            for(int i=0; i<3; i++) 
            {
                printf("%f\t",tauc1[i]);
            }
            moment_calc (tauc1, mag_field,moment);
            printf("\n\r moment values ");
            for(int i=0; i<3; i++) 
            {
                printf("%f\t",moment[i]);
            }
            FUNC_ACS_GENPWM(moment);                   
        }
        t.reset();
    }
}

//---------------------------------------------------BEACON--------------------------------------------------------------------------------------------

int beac_flag=0;                                                            //To receive telecommand from ground. Beacon stopped when telecomand recieved durring 



/*void T_BEA_TELECOMMAND(void const *args)
{
    char c = pc.getc();
    if(c=='a')
    {
        printf("Telecommand detected\n\r");
        beac_flag=1;
    }
}
*/

void T_BEA(void const *args)
{
    
    while(1)
    {
        Thread::signal_wait(0x3);
        printf("\n\rTHIS IS BEACON    %f\n\r",t1.read());
        t.start();
        FUNC_BEA();
        if(beac_flag==1)                            // use scheduler instead
        {
            Thread::wait(600000);
            beac_flag = 0;
        }
        printf("The time to execute beacon thread is %f seconds\n\r",t.read());
        t.reset();
    }
}



extern SensorDataQuantised SensorQuantised;                 // ????????

/*-------------------------------------------------------------------------------------------------------------------------------------------
-------------------------------------------------------WATCHDOG----------------------------------------------------------------------------*/
DigitalOut trigger(PIN63);                                             // has to be changed
void T_WDT(void const * args)
{
    trigger = 1;                            // gpio to WD input
    while(true)
    {
        Thread::signal_wait(0x5);                               //signal set from scheduler or sthing. r RTOS timer nce the timing is finalized
        printf("\n\rEntered WD\n\r");
        trigger = !trigger;                                     /// falling edge triggered 
    }
}

//---------------------------------------------------------------------------------------------------------------------------------------------------
//TASK 5 : i2c data
//---------------------------------------------------------------------------------------------------------------------------------------------------

void FUNC_I2C_WRITE2CDMS(char *data, int length=1)                  /// BAE to CDMS read/write
{
    int slave_status = 1;
    //int inter_test = interrupt;
    //int slr = slave.receive();
    //wait_ms(20);
    //printf("\n\r time is %d\n",t2.read_us());
    //if(interrupt ==1)
    //{ 
       wait_us(100);
        int slave_r = slave.receive();
        printf("\n%d\r",slave_r);
   //       printf("\n%d\r",slave.receive()); 
        t2.stop();
       // wait_ms(2);
        if(slave.receive() == 0)                    // 0 when not ack refer doc.
            //t2.stop();
        if( slave.receive()==1) // slave to master
        {
          //  t2.stop();
            t3.start();
            slave_status=slave.write(data,length);              // ack to
            
            t3.stop();
            slave.stop();  
            //printf("\n\r slave status %d",slave.receive());
        }
        if( slave.receive()==3 ||  slave.receive()==2)     // master to slave
        {
            //t2.stop();
            t3.start();
            slave_status=slave.read(data,length);
            t3.stop();
            slave.stop();
            //printf("\n\r slave status %d",slave.receive());
        }
    //}
  //  printf("\n\r time taken to receive intrpt 4m cdms %d",i1.read_us());
    //i1.reset();
    printf("\n\r slave status %d %d ",t2.read_us(),t3.read_us());
   // printf("\n\r time taken from interrupt to reach i2c fn %d",t2.read_us());
    //t2.stop();
    t2.reset();
    //printf("\n\r time to execute i2c function %d",t3.read_us());
    t3.reset();
}
   
char data_send[25],data_receive;
void T_I2C_BAE(void const * args)
{
     while(1)
    {
        Thread::signal_wait(0x4);
        int something = interrupt;
       // printf("\n\r interrupt %d",interrupt);     
        if(i2c_status == 0 )    // read from CDMS (master)
        
        {
           // wait_ms(23);
            FUNC_I2C_WRITE2CDMS(&data_receive,1);
            /*i2c_data * i2c_data_r = i2c_data_receive.alloc();
            i2c_data_r->data = data_receive;
            i2c_data_r->length = 1;
            i2c_data_receive.put(i2c_data_r);*/
            printf("\n\r Data received from CDMS is %c \n\r",data_receive);
           // FUNC_I2C_TC_EXECUTE(data_receive);                       //  telecommand      // This has to be done from a differen thread 
            
        }
        else if(i2c_status ==1)
        {
            osEvent evt = i2c_data_send.get();                      // 
            if (evt.status == osEventMail)                              //
            {
                i2c_data *i2c_data_s = (i2c_data*)evt.value.p;              //syntax recieving address of data from queue and storing it in struct
                strcpy(data_send,i2c_data_s -> data);                       // -> data from pointer
               // wait_ms(13);
                
                FUNC_I2C_WRITE2CDMS(data_send,25);                          
                printf("\n\rData sent to CDMS is %s\n\r",data_send);
                
                i2c_data_send.free(i2c_data_s);             // freeing the memory location from queue
                i2c_status = 0;
            }
        }  
           
    }
}

        

void FUNC_I2C_INT()             // ISR from CDMS to BAE
{
   //i1.stop();
   
  // t3.start();
   ptr_t_i2c->signal_set(0x4);                  // printf dosen't work....why??????????????????
   //printf("\n ceckh\n");
   t2.start();
 //      printf("\n\r time taken from interrupt to reach i2c fn %d",t2.read_us());
}

void FUNC_I2C_IR2CDMS()
{                                   // structure cannot sent via i2c so struct quantized to string n send to cdms n store in SD
        data_ready=0; 
        //char data[25];
        strcpy(hk_data,"hk_Data");
        strcat(hk_data,SensorQuantised.Voltage);
        strcat(hk_data,SensorQuantised.Current); 
        strcat(hk_data,SensorQuantised.Temperature); 
        strcat(hk_data,SensorQuantised.PanelTemperature);
        strcat(hk_data,SensorQuantised.AngularSpeed);
        strcat(hk_data,SensorQuantised.Bnewvalue);
        char fdata[5] = {SensorQuantised.BatteryTemperature,SensorQuantised.faultpoll,SensorQuantised.faultir,SensorQuantised.power_mode};

        /*strcat(hk_data,sfaultpoll);
        strcat(hk_data,sfaultir);
        strcat(hk_data,spower_mode);*/
        strcat(hk_data,fdata);
        printf("\n\r hk data being sent %s ",hk_data);
        //for(int i=0;i<100000000000;i++)
        //;
            
        /*for(int d=0;d<23;d++)                          //was written just to check hk data
        {
            if(hk_data[d]>10)
            printf("\n\rhk data : %d\n\r",hk_data[d]);
        }   */ 
       
        //data = pcslave.getc();
        
        i2c_status=1;
        i2c_data * i2c_data_s = i2c_data_send.alloc();  // writing to queue _____ dynamic memory allocation
        strcpy(i2c_data_s->data,hk_data);
        i2c_data_s->length = 25;
        i2c_data_send.put(i2c_data_s); 
        data_ready=1;
     //   i1.start();
        //temp = i2c_status;
}
    

//------------------------------------------------------------------------------------------------------------------------------------------------
//TELECOMMAND
//------------------------------------------------------------------------------------------------------------------------------------------------
void FUNC_I2C_TC_EXECUTE (char command)  
{ switch(command)
   {   case '0' : printf("\n\rcommand 0 executed");      // assuming telecommand to switch of beacon 
                  beac_flag = 1;
                  bea_timeout.attach(&FUNC_BEA_TIMEOUT,35.0 );
                  printf("\n\rbeacon switched off");
       break;
       case '1' : printf("\n\rcommand 1 executed");
       break;
       case '2' : printf("\n\rcommand 2 executed");
       break;
       case '3' : printf("\n\rcommand 3 executed");
    }
}

void FUNC_BEA_TIMEOUT()
{
  // printf("\n\rbea on");
   beac_flag = 0;
  
}  
   

//------------------------------------------------------------------------------------------------------------------------------------------------
//SCHEDULER                   RTOS timer can be called periodically
//------------------------------------------------------------------------------------------------------------------------------------------------
int beacon_sc = 3;
uint16_t schedcount=1;
void T_SC(void const *args)
{
    //DRDY=0;
    printf("\n\rThe value of i in scheduler is %d\n",schedcount);
    if(schedcount == 65532)                         //to reset the counter  // when it reaches here back to intial state
    {
        schedcount = 0;
    }
    
    if(schedcount%1==0)
    {
      ptr_t_acs -> signal_set(0x1);
      ptr_t_wdt -> signal_set(0x5);
    }
    if(schedcount%2==0)
    {
       // ptr_t_fault -> signal_set(0x2);
      ptr_t_hk_acq -> signal_set(0x2);
        
    }
    if(schedcount%beacon_sc==0)
    {
        if(beac_flag==0)
        {
            ptr_t_bea -> signal_set(0x3);
        }
    }
    schedcount++;
}
    
//---------------------------------------------------------------------------------------------------------------------------------------------

int main()
{
    t1.start();
    printf("\n\rIITMSAT BAE Activated \n");
    //INIT_PNI();                                       // Initializing mnm blue
    //FUNC_ACS_MAG_INIT();                              // Initializing magnetometer
    //FUNC_ACS_INIT_GYR();                              // Initializing Gyroscope
    slave.address(0x20);                              // setting slave address for BAE for I2C communication
    //init_beacon();
    ptr_t_hk_acq = new Thread(T_HK_ACQ);
    ptr_t_acs = new Thread(T_ACS);                    
    ptr_t_bea = new Thread(T_BEA);
    ptr_t_i2c = new Thread(T_I2C_BAE);
    //ptr_t_sc = new Thread(T_SC);
    ptr_t_wdt = new Thread(T_WDT);
  
    interrupt_fault();                      // Dummy function called when a fault interrupt is detected // intrrupt based fault
    
    ptr_t_acs->set_priority(osPriorityAboveNormal);
    ptr_t_i2c->set_priority(osPriorityHigh);
    ptr_t_hk_acq->set_priority(osPriorityAboveNormal);
    ptr_t_bea->set_priority(osPriorityAboveNormal);
    //ptr_t_sc->set_priority(osPriorityAboveNormal);
    ptr_t_wdt -> set_priority(osPriorityIdle);
    
  
   // ----------------------------------------------------------------------------------------------
    printf("\n\r T_ACS priority is %d",ptr_t_acs->get_priority());
    printf("\n\r T_HK_ACQ priority is %d",ptr_t_hk_acq->get_priority());
    printf("\n\r T_BEA priority is %d",ptr_t_bea->get_priority());  
    RtosTimer t_sc_timer(T_SC,osTimerPeriodic);     //values -3 tpo +3
    t_sc_timer.start(10000);
    printf("\n\r%f\n\r",t1.read()); 
    FUNC_I2C_TC_EXECUTE ('0');
    printf("\n \r check1 \n"); 
   interrupt.rise(&FUNC_I2C_INT);                             //interrupt received from CDMS
    while(1)                                                   //required to prevent main from terminating
    {   
        Thread::wait(5000);                     // main by default a thread of priority 0
       // printf("\n \r check \n"); 
       // FUNC_I2C_TC_EXECUTE ('0');               // this has to come through i2c from cdms. just for testing beacon on/off
       
      //
      
    }
    
}
