#include "HK.h"
#include "pin_config.h"
 
 
//GPIO pins used=> D2-D12, A0-A1

DigitalOut SelectLinesA[]={PIN43,PIN44,PIN45,PIN46};         //to mux1=>voltage mux , PTA 13-16 , CHNGE TO PIN43 LATER
DigitalOut SelectLinesB[]={PIN56,PIN57,PIN58,PIN59};         //to mux2=>current mux(differential mux) , PTB 3,7,8,9
DigitalOut SelectLinesC[]={PIN64,PIN65,PIN66,PIN67};         //to mux3=>temp mux   PTB 18-21

//--------------------------------------------MSB is SelectLines[0],LSB is SelectLines[3]-------------------------------- 

AnalogIn CurrentInput(PIN53);                                // output from Current Mux PTB0
AnalogIn VoltageInput(PIN54);                                // output from Voltage Multiplexer  PTB1
AnalogIn TemperatureInput(PIN55);                            /*PTB2 output from Temperature Multiplexer,thermistor Multiplexer- same multiplexer for both(lines 1-4 for thermistor,line 0 for temperature sensor)*/ 



int quantiz(float start,float step,float x)                  // accepts min and measured values and step->quantises on a scale 0-15..(4 bit quantisation)
{
    int y=(x-start)/step;
    if(y<=0)y=0;
    if(y>=15)y=15;
    return y;
}
 
void init_beacon(ShortBeacy* x,SensorDataQuantised y)  
{
    (*x).Voltage[0]=2;                                       //quantised value
    (*x).Temp[0]=y.PanelTemperature[0];                      //quantised value
    (*x).Temp[1]=y.PanelTemperature[1];                      //quantised value
    (*x).AngularSpeed[0]=y.AngularSpeed[0];
    (*x).AngularSpeed[1]=y.AngularSpeed[1];
    
    (*x).SubsystemStatus[0]=145;                             //dummy values----------to be changed-------------------
    (*x).ErrorFlag[0]=3;                                     //dummy values----------to be changed-------------------
}

SensorData Sensor; 
SensorDataQuantised SensorQuantised;
ShortBeacy Shortbeacon;
void FUNC_HK_MAIN()             
{
    //define structure variables    
 
    //initialise all selectlines to zeroes->1st line of muxes selected
    SelectLinesA[0]=SelectLinesA[1]=SelectLinesA[2]=SelectLinesA[3]=0;
    SelectLinesB[0]=SelectLinesB[1]=SelectLinesB[2]=0;
    SelectLinesC[0]=SelectLinesC[1]=SelectLinesC[2]=SelectLinesC[3]=0;
    
    int LoopIterator;
    int SelectLineIterator;
    
    float resistance_thermistor,voltage_thermistor;//for thermistor
 
    //measurement from voltage sensor=> 16 sensors in place
    for(LoopIterator=0; LoopIterator<16; LoopIterator++) 
    {       
        //read the sensor values and stores them in 'SensorData' structure's variable 'Sensor'
        Sensor.Voltage[LoopIterator]=(VoltageInput.read()*3.3*5.545454);//resistors in voltage divider=>15Mohm,3.3Mohm
               
        if(LoopIterator%2==0)
            SensorQuantised.Voltage[LoopIterator/2]=quantiz(vstart,vstep,Sensor.Voltage[LoopIterator]);
                           
        else
            SensorQuantised.Voltage[(LoopIterator)/2]=SensorQuantised.Voltage[(LoopIterator)/2]<<4+quantiz(vstart,vstep,Sensor.Voltage[LoopIterator]);
            
        //iterate the select lines from 0 to 15
        for(SelectLineIterator=3;SelectLineIterator>=0;SelectLineIterator--)
        {
            if(SelectLinesA[SelectLineIterator]==0)
            {
                SelectLinesA[SelectLineIterator]=1;
                break;
            }
            else SelectLinesA[SelectLineIterator]=0;
        }
    
        wait_us(10.0); //  A delay of 10 microseconds between each sensor output. Can be changed.
    }
 
 
    //measurement from current sensor=>  8 sensors in place 
    for(LoopIterator=0; LoopIterator<8; LoopIterator++) 
    {       
        //read the sensor values and stores them in 'SensorData' structure variable 'Sensor'
        Sensor.Current[LoopIterator]=(CurrentInput.read()*3.3/(50*rsens));
        if(LoopIterator%2==0)
            SensorQuantised.Current[LoopIterator/2]=quantiz(cstart,cstep,Sensor.Current[LoopIterator]);
        else
            SensorQuantised.Current[(LoopIterator)/2]=SensorQuantised.Current[(LoopIterator)/2]<<4+quantiz(cstart,cstep,Sensor.Current[LoopIterator]);

        //iterate the select lines from 0 to 7
        for(SelectLineIterator=2;SelectLineIterator>=0;SelectLineIterator--)
        {
            if(SelectLinesB[SelectLineIterator]==0)
            {
                SelectLinesB[SelectLineIterator]=1;
                break;
            }
            else SelectLinesB[SelectLineIterator]=0;
    
        }
    
        wait_us(10.0); //  A delay of 10 microseconds between each sensor output. Can be changed.
    }
    
    
    //measurement of temperature
    //temperature measurement=> 4 thermistors, 1 temperature sensor
    //mux line 1=>temp sensor, mux lines 2 to 5 =>thermistors

    for(LoopIterator=0; LoopIterator<5; LoopIterator++) 
    {        
        //read the sensor values and stores them in 'SensorData' structure variable 'Sensor'
        Sensor.Temperature[LoopIterator]=(-90.7*3.3*TemperatureInput.read()+190.1543);
        voltage_thermistor=TemperatureInput.read()*3.3;//voltage across thermistor
        resistance_thermistor=24000*voltage_thermistor/(3.3-voltage_thermistor);//resistance of thermistor
        if (LoopIterator==0)
        {
            printf(" \n\rTemp =%f",-90.7*3.3*TemperatureInput.read()+190.1543);
        }
        
        if(LoopIterator%2==0)
        {                
            if(LoopIterator<1)                      //->corresponding to temperature sensor
                SensorQuantised.Temperature[(LoopIterator)/2]=quantiz(tstart,tstep,Sensor.Temperature[LoopIterator]);
         
            else                                    //->corresponding to thermistor
            {    
                if(voltage_thermistor<1.378) //Temperature>12 degC
                    Sensor.PanelTemperature[(LoopIterator-1)]=(3694/log(24.032242*resistance_thermistor));
                    
                else   
                    Sensor.PanelTemperature[(LoopIterator-1)]=(3365.4792/log(7.60404*resistance_thermistor));
                    
                    
                SensorQuantised.PanelTemperature[(LoopIterator-1)/2]=quantiz(tstart_thermistor,tstep_thermistor,Sensor.PanelTemperature[(LoopIterator-1)]);
                    
            }
        } 
        else
        {           
            if(LoopIterator<1)
                SensorQuantised.Temperature[(LoopIterator)/2]=SensorQuantised.Temperature[(LoopIterator)/2]<<4+quantiz(tstart,tstep,Sensor.Temperature[LoopIterator]); 
            
            else
            {  
                if(voltage_thermistor<1.378) //Temperature>12 degC 
                    Sensor.PanelTemperature[LoopIterator-1]=(3694/log(24.032242*resistance_thermistor));
                else
                    Sensor.PanelTemperature[LoopIterator-1]=(3365.4792/log(7.60404*resistance_thermistor));
                    
                SensorQuantised.PanelTemperature[(LoopIterator-1)/2]=SensorQuantised.PanelTemperature[(LoopIterator-1)/2]<<4+quantiz(tstart_thermistor,tstep_thermistor,Sensor.PanelTemperature[LoopIterator-1]);
            }
        }
       // The following lines are used to iterate the select lines from 0 to 4
       for(SelectLineIterator=3;SelectLineIterator>=0;SelectLineIterator--)
       {
            if(SelectLinesC[SelectLineIterator]==0)
            {
                SelectLinesC[SelectLineIterator]=1;
                break;
            }
            else SelectLinesC[SelectLineIterator]=0;
        }
    
        wait_us(10.0); //  A delay of 10 microseconds between each sensor output. Can be changed.
    }


    //update magnetometer data->
    //populate values in structure variable 'Sensor' from data to be given by Green
     SensorQuantised.AngularSpeed[0]=quantiz(AngularSpeed_start,AngularSpeed_step,Sensor.AngularSpeed[1]);
     SensorQuantised.AngularSpeed[0]=SensorQuantised.AngularSpeed[0]<<4+quantiz(AngularSpeed_start,AngularSpeed_step,Sensor.AngularSpeed[0]);
     SensorQuantised.AngularSpeed[1]=quantiz(AngularSpeed_start,AngularSpeed_step,Sensor.AngularSpeed[2]);
     
    //update gyro data->
    //populate values in structure variable 'Sensor' from data to be given by Green
     SensorQuantised.Bnewvalue[0]=quantiz(Bnewvalue_start,Bnewvalue_step,Sensor.Bnewvalue[1]);
     SensorQuantised.Bnewvalue[0]=SensorQuantised.Bnewvalue[0]<<4+quantiz(Bnewvalue_start,Bnewvalue_step,Sensor.Bnewvalue[0]);
     SensorQuantised.Bnewvalue[1]=quantiz(Bnewvalue_start,Bnewvalue_step,Sensor.Bnewvalue[2]);

     //update beacon structure
     init_beacon(&Shortbeacon,SensorQuantised);//Shortbeacon is passed 
     printf("\n here temperature :%d",SensorQuantised.Temperature);    
}


    
