#include "mbed.h"
#include "rtos.h"

const int addr = 0x20;                     //slave address 
I2C master (D14,D15);                      //configure pins p27,p28 as I2C master
Serial pc (USBTX,USBRX);
DigitalOut master_intrpt(D9);
InterruptIn slave_intrpt(D10);

bool ack0 =true; 
bool ack1 =true; 


unsigned char* data_reg = (unsigned char*)0x40067004;
unsigned char* status_reg = (unsigned char*)0x40067003;
unsigned char* c1_reg = (unsigned char*)0x40067002;
unsigned char* c2_reg = (unsigned char*)0x40067005;
unsigned char* freq_reg = (unsigned char*)0x40067001;

char slave_data;
void FUNC_I2C_MASTER_READ()
{
            master.frequency(100000);                       //set clock frequency
            master_intrpt = 1;
            while(ack0)
            {
            ack0 =  master.read(addr|1,&slave_data,1);
            }
            if(!ack0 )
            {
                printf("\n\r master has read %c from slave\n\r",slave_data);
                //printf("\n \r %d %d %d %d %d\n",*data_reg,*status_reg,*c1_reg,*c2_reg,*freq_reg);
            }
            else
            {
                printf("\n\r data not read by master \n");
            }
            master_intrpt = 0; 
}
            
void FUNC_INT()
{
      FUNC_I2C_MASTER_READ();
}

char writedata;
void FUNC_MASTER_WRITE()
{
    char data = pc.getc();
    master_intrpt = 1;
    while(ack1)
    {
        ack1 = (bool) master.write(addr|0x00,&writedata,1);
    }
    if(!ack1 )
           {
                    printf("master has written %c to slave\n\r",writedata);
                    //printf("\n \r %d %d %d %d %d\n",*data_reg,*status_reg,*c1_reg,*c2_reg,*freq_reg);
           }
    else
    {
        printf("\n\r data not written to slave \n");
    master_intrpt = 0;
    //printf("\n \r %d %d %d %d %d\n",*data_reg,*status_reg,*c1_reg,*c2_reg,*freq_reg);
    }
}
    

int main()
{   
    printf("\nstarted master\n");
    master_intrpt = 0;
    slave_intrpt.rise(&FUNC_INT);
 
    //master.start();  
    while(1)
    { 
      FUNC_MASTER_WRITE();  
      
    }
}           