#include<mbed.h>
#include "pni.h" //pni header file
Serial pc(USBTX,USBRX); //for usb communication
I2C i2c (PTC9,PTC8); //PTC2-sda,PTC1-scl
void INIT_PNI(void); //initialization of registers happens
float *EXECUTE_PNI(); //data is obtained
void T_OUT(); //timeout function to stop infinite loop
Timeout to; //Timeout variable to
int toFlag; 
void T_OUT()
{
    toFlag=0; //as T_OUT function gets called the while loop gets terminated
}

//DEFINING VARIABLES
char cmd[2];
char raw_gyro[6];
char raw_mag[6];
char store,status;
int16_t bit_data;
float gyro_data[3], mag_data[3],combined_values[6],*data;
float senstivity_gyro =6.5536; //senstivity is obtained from 2^15/5000dps
float senstivity_mag  =32.768; //senstivity is obtained from 2^15/1000microtesla
float gyro_error[3]= {0,0,0}, mag_error[3]= {0,0,0};

int main(void)
{

    printf("\\program starting\n");
    INIT_PNI();
    data=EXECUTE_PNI(); //the angular velocity is stored in the first 3 values and magnetic field values in next 3
    pc.printf("gyro values\n"); //printing the angular velocity and magnetic field values
    for(int i=0; i<3; i++) {
        pc.printf("%f\t",data[i]);
    }
    pc.printf("mag values\n");
    for(int i=3; i<6; i++) {
        pc.printf("%f\t",data[i]);
    }
}

void  INIT_PNI()
{
    cmd[0]=RESETREQ;
    cmd[1]=BIT_RESREQ;
    i2c.write(SLAVE_ADDR,cmd,2); //When 0x01 is written in reset request register Emulates a hard power down/power up
    wait_ms(2000); //waiting for loading configuration file stored in EEPROM
    cmd[0]=SENTRALSTATUS;
    i2c.write(SLAVE_ADDR,cmd,1);
    i2c.read(SLAVE_ADDR_READ,&store,1);
    wait_ms(100);
    //to check whether EEPROM is uploaded
    switch((int)store) { 
        case(3): {
            break;
        }
        case(11): {
            break;
        }
        default: {
            cmd[0]=RESETREQ;
            cmd[1]=BIT_RESREQ;
            i2c.write(SLAVE_ADDR,cmd,2);
            wait_ms(2000);
        }
    }
    //pc.printf("Sentral Status is %x\n",(int)store);
    cmd[0]=HOST_CTRL; //0x01 is written in HOST CONTROL register to enable the sensors
    cmd[1]=BIT_RUN_ENB;
    i2c.write(SLAVE_ADDR,cmd,2);
    wait_ms(100);
    cmd[0]=MAGRATE; //Output data rate of 100Hz is used for magnetometer
    cmd[1]=BIT_MAGODR;
    i2c.write(SLAVE_ADDR,cmd,2);
    wait_ms(100);
    cmd[0]=GYRORATE; //Output data rate of 150Hz is used for gyroscope
    cmd[1]=BIT_GYROODR;
    i2c.write(SLAVE_ADDR,cmd,2);
    wait_ms(100);
    cmd[0]=ALGO_CTRL; //When 0x00 is written to ALGO CONTROL register we get scaled sensor values
    cmd[1]=0x00;
    i2c.write(SLAVE_ADDR,cmd,2);
    wait_ms(100);
    cmd[0]=ENB_EVT; //enabling the error,gyro values and magnetometer values
    cmd[1]=BIT_EVT_ENB;
    i2c.write(SLAVE_ADDR,cmd,2);
    wait_ms(100);
}

float *EXECUTE_PNI()
{
    toFlag=1; //toFlag is set to 1 so that it enters while loop
    to.attach(&T_OUT,2); //after 2 seconds the while loop gets terminated 
    while(toFlag) {
        cmd[0]=EVT_STATUS;
        i2c.write(SLAVE_ADDR,cmd,1);
        i2c.read(SLAVE_ADDR_READ,&status,1);
        wait_ms(100);
        pc.printf("\nEvent Status is %x\n",(int)status);
        //if the 6th and 4th bit are 1 then it implies that gyro and magnetometer values are ready to take
        if(((int)status&40)==40) {
            cmd[0]=GYRO_XOUT_H; //0x22 gyro LSB of x 
            i2c.write(SLAVE_ADDR,cmd,1);
            i2c.read(SLAVE_ADDR_READ,raw_gyro,6);
            cmd[0]=MAG_XOUT_H; //LSB of x
            i2c.write(SLAVE_ADDR,cmd,1);
            i2c.read(SLAVE_ADDR_READ,raw_mag,6);
            //pc.printf("\nGyro Values:\n");
            for(int i=0; i<3; i++) {
                //concatenating gyro LSB and MSB to get 16 bit signed data values
                bit_data= ((int16_t)raw_gyro[2*i+1]<<8)|(int16_t)raw_gyro[2*i]; 
                gyro_data[i]=(float)bit_data;
                gyro_data[i]=gyro_data[i]/senstivity_gyro;
                gyro_data[i]+=gyro_error[i];
                //pc.printf("%f\t",gyro_data[i]);
            }
            //pc.printf("\nMag Values:\n");
            for(int i=0; i<3; i++) {
                //concatenating mag LSB and MSB to get 16 bit signed data values
                bit_data= ((int16_t)raw_mag[2*i+1]<<8)|(int16_t)raw_mag[2*i];
                mag_data[i]=(float)bit_data;
                mag_data[i]=mag_data[i]/senstivity_mag;
                mag_data[i]+=mag_error[i];
                //pc.printf("%f\t",mag_data[i]);
            }
            for(int i=0; i<3; i++) {
                combined_values[i]=gyro_data[i];
                combined_values[i+3]=mag_data[i];
            }
            return(combined_values); //returning poiter combined values
        } 
       //checking for the error
        else if (((int)status&2)==2) {
            INIT_PNI(); //when there is any error then Again inilization is done to remove error
        }
    }
}