#include "mbed.h"
#include "rtos.h"

const int addr = 0x20;                     //slave address 
I2C master (D14,D15);                      //configure pins p27,p28 as I2C master
Serial pc (USBTX,USBRX);
DigitalOut interrupt(D9);
InterruptIn data_ready(D10);
Thread * ptr_t_i2cmaster;

typedef struct
{
    char data;          // To avoid dynamic memory allocation
    int length;
}master_data;

Mail<master_data,16> master_data_receive;
Mail<master_data,16> master_data_send;
void FUNC_MASTER_WRITE();

void T_MASTER_READ(void const* args)
{
        
        while(1)
        {
            Thread::signal_wait(0x2);             //master reading from slave
            wait(0.5);
            interrupt = 1;
            printf("\nMaster executed\n\r");
            bool ack0 =true; 
            char *data_receive =  new char;
            *data_receive = 'b';
            master.frequency(100000);                       //set clock frequency
             
             
            while(ack0)
            { 
                master.start();                                 //initiating the data transfer
                ack0 =  master.read(addr,data_receive,1);
            }
            
            master_data * master_data_r = master_data_receive.alloc();
            master_data_r->data = *data_receive;
            master_data_r->length = 1;
            master_data_receive.put(master_data_r);
            printf("\n Data received from CDMS is %c\n\r",*data_receive);
            master_data_receive.free(master_data_r);
            
            delete data_receive;
            interrupt=0;
            
        }
}
 
void FUNC_MASTER_IR()
{
     ptr_t_i2cmaster->signal_set(0x2);               
}                   

/*void FUNC_TELECOMMAND()
{
    interrupt = 0;
    char writedata = pc.getc();
    interrupt = 1; 
    master_data * master_data_s = master_data_send.alloc();
    master_data_s->data = writedata;
    master_data_s->length = 1;
    master_data_send.put(master_data_s); 
    FUNC_MASTER_WRITE();
}*/
  
char* data_send =new char;  
void FUNC_MASTER_WRITE()
{
        printf("\n entered master write\n\r");
        
        interrupt = 0;
    *data_send = pc.getc();
    //printf("\n %c \n\r",*data_send);
    interrupt = 1; 
    /*master_data * master_data_s = master_data_send.alloc();
    master_data_s->data = writedata;
    master_data_s->length = 1;
    master_data_send.put(master_data_s); */
        
       /* osEvent evt = master_data_send.get();
            if (evt.status == osEventMail) 
            {
                master_data *master_data_s = (master_data*)evt.value.p;
                *data_send = master_data_s -> data;*/
                bool write2slave=true;
                bool master_status_write = true;
                master.frequency(100000);       //set clock frequency
                while(write2slave){                
                    master.start();                             //initiating the data transfer
                    master_status_write = (bool) master.write(addr|0x00,data_send,1);
                    if(master_status_write==0)
                    {
                    printf("master has written %c to slave\n\r",*data_send);
                    write2slave=false;
                    }
                }
               // master_data_send.free(master_data_s);
                
            //}
}            

int main()
{   
    
    printf("\nstarted master\n\r");
    ptr_t_i2cmaster = new Thread(T_MASTER_READ);
    data_ready.rise(&FUNC_MASTER_IR);
    while(1){
        FUNC_MASTER_WRITE(); 
    }
}