#include "mbed.h"
#include "rtos.h"

const int addr = 0x20;                     //slave address 
I2C master (D14,D15);                      //configure pins p27,p28 as I2C master
Serial pc (USBTX,USBRX);
DigitalOut interrupt(D9);
InterruptIn data_ready(D10);
Thread * ptr_t_i2cmaster;

void T_MASTER_READ(void const* args)
{
        while(1)
        {
            Thread::signal_wait(0x2);
            wait(0.5);
            interrupt = 1;
            printf("\nMaster executed\n");
            bool ack0 =true; 
            char *data =  new char;
            *data = 'b';
            master.frequency(100000);                       //set clock frequency
             
             
            while(ack0)
            { 
                master.start();                                 //initiating the data transfer
                ack0 =  master.read(addr,data,1);
            }
            if(!ack0)
            {
                printf("\n master has read %c from slave\n\r",*data);
            }    
            delete data;
            interrupt=0;
        }
}
 
void FUNC_MASTER_IR()
{
     ptr_t_i2cmaster->signal_set(0x2);               
}                   

void FUNC_MASTER_WRITE()
{
        char *writedata = new char;
        bool write2slave=true;
        bool master_status_write = true;
        interrupt = 0;
        *writedata = pc.getc();
        interrupt = 1; 
        master.frequency(100000);                        //set clock frequency
        while(write2slave){                
                master.start();                                 //initiating the data transfer
                master_status_write = (bool) master.write(addr|0x00,writedata,1);
                if(master_status_write==0)
                    {
                    printf("master has written %c to slave\n\r",*writedata);
                    write2slave=false;
                    }
        }
        delete writedata;
}            

int main()
{   
    
    printf("\nstarted master\n");
    ptr_t_i2cmaster = new Thread(T_MASTER_READ);
    data_ready.rise(&FUNC_MASTER_IR);
    while(1){
        FUNC_MASTER_WRITE(); 
    }
}