#include "mbed.h"
#include "rtos.h"

const int addr = 0x20;                     //slave address 
I2C master (D14,D15);                      //configure pins p27,p28 as I2C master
Serial pc (USBTX,USBRX);
DigitalOut interrupt(D9);
InterruptIn data_ready(D10);

int reset;

typedef struct
{
    char data;          // To avoid dynamic memory allocation
    int length;
}i2c_data;

//Mail<i2c_data,16> i2c_data_receive;
Mail<i2c_data,16> i2c_data_send;

Thread * ptr_t_i2c;
void FUNC_I2C_MASTER_FSLAVE(char * data,int length)
{
    //printf("press backspace for master to start \n\r");
    //while(1){
            //interrupt = 0;
      //  if(pc.getc()=='z'){
            //wait(0.5);
            interrupt = 1;
            printf("\nMaster executed\n");
            
          
            bool ack0 =true; 
            bool loopvariable0 =true;
            //char *data =  new char;
            //*data = 'b';
           
           
            
             master.frequency(100000);                       //set clock frequency
             //master.start();
            /*while(write2slave)
            {  *writedata = pc.getc();
            wait(0.5);
              
                printf("master clk freq setup and addressing slave\n\r");
                master.start();                                 //initiating the data transfer
                master_status_write = (bool) master.write(addr|0x00,writedata,1);
                if(master_status_write==0)
                {
                    printf("master has written %c to slave\n\r",*writedata);
                    write2slave=false;
                }
                    
                    
             }*/
             
            while(ack0 && data_ready ==1 )
            {
                //printf("2 master clk freq setup and addressing slave\n\r");
                
                master.start();                                 //initiating the data transfer
                ack0 =  master.read(addr,data,length);
            }
            if(!ack0)
            {
                    printf("\n master has read %s from slave\n\r",data);
                    loopvariable0=false;
            }
                //master.stop();
            
            //printf("done\n\r");
            //delete data;
            interrupt=0;
            printf("\n blahblah\n\r");
}

typedef struct {
    char Voltage[9];
    char Current[5];
    char Temperature[2];
    char PanelTemperature[3];//read by the 4 thermistors on solar panels
    char BatteryTemperature;    //to be populated   
    char faultpoll;             //polled faults
    char faultir;               //interrupted faults
    char power_mode;            //power modes
    char AngularSpeed[3];
    char Bnewvalue[3];
    
    //float magnetometer,gyro=>to be addes
} hk_data;
hk_data decode_data;

void TC_DECODE(char *data_hk)                  //getting the structure back from hk data sent by bae
{
    for(int i=0;i<=7;i++)
    {
    decode_data.Voltage[i] = data_hk[i];
    decode_data.Voltage[8] = '\0';
    }
    for(int i=0;i<=3;i++)
    {
    decode_data.Current[i] = data_hk[8+i];
    decode_data.Current[4] = '\0';
    }
    decode_data.Temperature[0] = data_hk[12];
    decode_data.Temperature[1] = '\0'; 
    for(int i=0;i<=1;i++)
    {
    decode_data.PanelTemperature[i] = data_hk[13+i];
    decode_data.PanelTemperature[2] = '\0';
    }
    decode_data.BatteryTemperature = data_hk[15];
    decode_data.faultpoll = data_hk[16];
    decode_data.faultir = data_hk[17];
    decode_data.power_mode = data_hk[18];
    for(int i=0;i<=1;i++)
    {
    decode_data.AngularSpeed[i] = data_hk[19+i];
    decode_data.AngularSpeed[2] = '\0';
    }
    for(int i=0;i<=1;i++)
    {
    decode_data.Bnewvalue[i] = data_hk[21+i];
    decode_data.Bnewvalue[2] = '\0';
    }
    printf("\n voltage %s\n\r",decode_data.Voltage);
    printf("\n current  %s\n\r",decode_data.Current);
    printf("\n faultpoll %c\n\r",decode_data.faultpoll);
}

            
void T_I2C_MASTER_FSLAVE(void const *args)
{
    char data_receive[25];
    while(1)
    {
        Thread::signal_wait(0x1);
        
        
        FUNC_I2C_MASTER_FSLAVE(data_receive,25);
        /*i2c_data * i2c_data_r = i2c_data_receive.alloc();
        strcpy(i2c_data_r->data , data_receive);
        i2c_data_r->length = 25;
        i2c_data_receive.put(i2c_data_r);*/
        printf("\n Data received from slave is %s\n\r",data_receive);
        TC_DECODE(data_receive);
    }
}

void FUNC_INT()
{
  
   ptr_t_i2c->signal_set(0x1);
     
}

char writedata;
bool write2slave;
bool master_status_write;
void FUNC_MASTER_WRITE()
{   //wait(1);
    write2slave=true;
   
    
     
    char data = pc.getc();
    interrupt = 1;
    i2c_data * i2c_data_s = i2c_data_send.alloc();
    i2c_data_s->data = data;
    i2c_data_s->length = 1;
    i2c_data_send.put(i2c_data_s); 
    master_status_write = true;
    
   // interrupt = 1; 

    osEvent evt = i2c_data_send.get();
            if (evt.status == osEventMail) 
            {
                i2c_data *i2c_data_s = (i2c_data*)evt.value.p;
                writedata = i2c_data_s -> data;
                master.frequency(100000);                        //set clock frequency
                while(write2slave && interrupt ==1 )
                {                
                printf("master clk freq setup and addressing slave\n\r");
                master.start();                                 //initiating the data transfer
                master_status_write = (bool) master.write(addr|0x00,&writedata,1);
                if(master_status_write==0)
                    {
                    printf("master has written %c to slave\n\r",writedata);
                    write2slave=false;
                    }
                i2c_data_send.free(i2c_data_s);
                }
            }
            interrupt = 0;
}

    

int main()
{   
    interrupt=0;
    ptr_t_i2c = new Thread(T_I2C_MASTER_FSLAVE);
    data_ready.rise(&FUNC_INT);
    printf("\nstarted master\n"); 
    while(1)
    { //Thread::wait(9000);
    //interrupt = 1;
      
      FUNC_MASTER_WRITE(); 
      //interrupt = 0; 
      ;
    }
}           