//to be saved as HK.h

#include "mbed.h"
#define tstart -40
#define tstep 8
#define tstep_thermistor 8//verify!!
#define tstart_thermistor -40
#define vstart 3.3
#define vstep 0.84667
#define cstart 0.0691
#define cstep 0.09133
#define rsens 0.095
#define Bnewvalue_start -100//in microTesla...max possible field is .0001 T 
#define Bnewvalue_step 13.333
#define AngularSpeed_start -10//max possible ang. velocity in space is 10 deg/sec
#define AngularSpeed_step 1.3333 

typedef struct SensorData
{
    float Voltage[16];
    float Current[8];
    float Temperature[1];
    float PanelTemperature[4];
    float BatteryTemperature;   //to be populated
    char faultpoll;             //polled faults
    char faultir;               //interrupted faults
    char power_mode;            //power modes
    
    float AngularSpeed[3];      //in order x,y,z
    float Bnewvalue[3];         //in order Bx,By,Bz
   
    
} SensorData;

 
typedef struct SensorDataQuantised {
    char Voltage[8];
    char Current[4];
    char Temperature[1];
    char PanelTemperature[2];//read by the 4 thermistors on solar panels
    char BatteryTemperature;    //to be populated   
    char faultpoll;             //polled faults
    char faultir;               //interrupted faults
    char power_mode;            //power modes
    char AngularSpeed[2];
    char Bnewvalue[2];
    
    //float magnetometer,gyro=>to be addes
} SensorDataQuantised;
 
 
typedef struct ShortBeacon 
{
    char Voltage[1];                            //battery voltage from gauge, needs  to be quantised
    char AngularSpeed[2];                       //all the 3 data
    char SubsystemStatus[1];                    //power modes
    char Temp[2];                               //temp of solar panel
    //Temp[0]'s LSB=> PanelTemperature[0], Temp[0]'s MSB=> PanelTemperature[1], Temp[1]'s LSB=> PanelTemperature[2], Temp[1]'s MSB=> PanelTemperature[3]
    char ErrorFlag[1];                          //fault
}ShortBeacy; 
 
 
 
void FUNC_HK_MAIN();
 
int quantiz(float start,float step,float x);
void init_beacon(ShortBeacy* x,SensorDataQuantised y);
