#include "mbed.h"
#include "rtos.h"
#include "HK.h"
#include "slave.h"
#include "beacon.h"
#include "ACS.h"
#include "fault.h"
#include "slave.h"
#include "mnm.h"

Serial pc(USBTX, USBRX);

//extern DigitalOut DRDY;
InterruptIn interrupt(D9);
InterruptIn master_reset(D8);


Timer t;                                                        //To know the time of execution each thread
Timer t1;
                                                       //To know the time of entering  of each thread
Timer t2;
Timer t3;
Timer t4;






Thread *ptr_t_hk_acq;
Thread *ptr_t_acs;
//Thread *ptr_t_acs_write2flash;
Thread *ptr_t_bea;
//Thread *ptr_t_bea_telecommand;
//Thread *ptr_t_fault;
Thread *ptr_t_i2c;
Thread *ptr_t_wdt;  



//I2CSlave slave(D14,D15);                       //configuring pins p27, p28 as I2Cslave


DigitalOut data_ready(D10);
int i2c_status=0;                                 //read/write mode for i2c 0 : write2slave, 1 : write2master
int reset=0;
int temp;

typedef struct
{
    char data[25];          // To avoid dynamic memory allocation
    int length;
}i2c_data;






//Mail<i2c_data,16> i2c_data_receive;
Mail<i2c_data,16> i2c_data_send;

//--------------------------------------------------------------------------------------------------------------------------------------------------
//TASK 2 : HK
//--------------------------------------------------------------------------------------------------------------------------------------------------

char hk_data[25];
extern SensorDataQuantised SensorQuantised;
void T_HK_ACQ(void const *args)
{
    
    while(1)
    {
        Thread::signal_wait(0x2);
        SensorQuantised.power_mode='3';
        printf("\n\rTHIS IS HK    %f\n\r",t1.read());
        t.start();
        FUNC_HK_FAULTS();
        FUNC_HK_POWER(SensorQuantised.power_mode);                                                   //The power mode algorithm is yet to be obtained
        FUNC_HK_MAIN();                                                             //Collecting HK data
        //thread_2.signal_set(0x4);
        //FUNC_I2C_SLAVE_MAIN(25);    
        FUNC_I2C_IR2CDMS();
        t.stop();
        printf("The time to execute hk_acq is %f seconds\n\r",t.read());
        t.reset();
    }
}

//---------------------------------------------------------------------------------------------------------------------------------------
//TASK 1 : ACS
//---------------------------------------------------------------------------------------------------------------------------------------

int acs_pflag = 1;
void T_ACS(void const *args)
{
    float *mag_field;
    float *omega;
    float mag_field1[3];
    float omega1[1];
    float moment[3];
    float *mnm_data;
    while(1)
    {
        Thread::signal_wait(0x1);
        printf("\n\rTHIS IS ACS   %f\n\r",t1.read());
        t.start();
        mag_field= FUNC_ACS_MAG_EXEC();                              //actual execution
        omega = FUNC_ACS_EXEC_GYR();
        printf("\n\r gyr 1 value %f",omega[0]);
        mnm_data=EXECUTE_PNI(); //the angular velocity is stored in the first 3 values and magnetic field values in next 3
        printf("\n\rmnm gyro values\n"); //printing the angular velocity and magnetic field values
        for(int i=0; i<3; i++) 
        {
        printf("%f\t",mnm_data[i]);
        }
        printf("\n\r mnm mag values\n");
        for(int i=3; i<6; i++) {
        printf("%f\t",mnm_data[i]);
        }
        for(int i = 0 ; i<3;i++)
        {
            omega1[i] = mnm_data[i];
        }
        for( int i = 3;i<6;i++)
        {
            mag_field1[i-3] = mnm_data[i];
        }
        if(acs_pflag == 1)
        {
        FUNC_ACS_CNTRLALGO(mag_field1,omega1,moment);
        printf("\n\r control algo values ");
        for(int i=0; i<3; i++) 
        {
        printf("%f\t",moment[i]);
        }
        FUNC_ACS_GENPWM(moment);                     
        }
       
        t.reset();
    }
}
/*
void T_ACS_WRITE2FLASH(void const *args)
{
    while(1)
    {
        //printf("Writing in the flash\n\r");
        osEvent evt = q_acs.get();
        if(evt.status == osEventMail)
        {
            sensor_data *ptr = (sensor_data*)evt.value.p;
            FUNC_ACS_WRITE2FLASH(ptr);
            q_acs.free(ptr);
        }
        printf("Writing acs data in the flash\n\r");
    }
}

*/
//---------------------------------------------------BEACON--------------------------------------------------------------------------------------------

int beac_flag=0;                                                            //To receive telecommand from ground.


/*void T_BEA_TELECOMMAND(void const *args)
{
    char c = pc.getc();
    if(c=='a')
    {
        printf("Telecommand detected\n\r");
        beac_flag=1;
    }
}
*/

void T_BEA(void const *args)
{
    
    while(1)
    {
        Thread::signal_wait(0x3);
        printf("\n\rTHIS IS BEACON    %f\n\r",t1.read());
        t.start();
        
        
            
        FUNC_BEA();
            
        
        if(beac_flag==1)
        {
            Thread::wait(600000);
            beac_flag = 0;
        }
        
        printf("The time to execute beacon thread is %f seconds\n\r",t.read());
        t.reset();
    }
}

//---------------------------------------------------------------------------------------------------------------------------------------------------
//TASK 4 : FAULT MANAGEMENT
//---------------------------------------------------------------------------------------------------------------------------------------------------
//Dummy fault rectifier functions

extern SensorDataQuantised SensorQuantised;


/*void T_FAULT(void const *args)
{   
    Sensor.power_mode='0';
    while(1)
    {
        Thread :: signal_wait(0x2);
        FAULTS();
        POWER(Sensor.power_mode);
        //Sensor.power_mode++;            //testing ... should be removed
    }    
}
*/
/*-------------------------------------------------------------------------------------------------------------------------------------------
-------------------------------------------------------WATCHDOG----------------------------------------------------------------------------*/
DigitalOut trigger(PIN63);                                             // has to be changed
void T_WDT(void const * args)
{
    trigger = 1;
    while(true)
    {
        Thread::signal_wait(0x5);                               //signal set from scheduler or sthing. r RTOS timer nce the timing is finalized
        printf("\n\rEntered WD\n\r");
        trigger = !trigger;
    }
}

//---------------------------------------------------------------------------------------------------------------------------------------------------
//TASK 5 : i2c data
//---------------------------------------------------------------------------------------------------------------------------------------------------






/*void FUNC_I2C_WRITE2CDMS(char *data, int length=1)
{
       int slave_status = 1;
       //t2.stop();
       if(interrupt ==1)
       {

           if(slave.receive() == 0)
           t2.stop();
           //t4.stop();     
           //printf("\n\r %d ",slave.receive());  
           if( slave.receive()==1)
           {
               t2.stop();
               
               slave_status=slave.write(data,length);
               t3.stop();
            
            }
            else if( slave.receive()==3 ||  slave.receive()==2)
            {
                t2.stop();
                //t3.start();
                slave_status=slave.read(data,length);
                t3.stop();
            }
         
            
    }
           
            printf("\n\r%d\r",t2.read_us());
            t2.reset();
            printf("\n\r%d\r",t3.read_us());
            t3.reset();
     
}*/
/*   
char data_send[25],data_receive;
void T_I2C_BAE(void const * args)
{
     //char data_send,data_receive;
    while(1)
    {
        Thread::signal_wait(0x4);
       // printf("\n\r entered thread");
        if(i2c_status == 0 )
        {
            wait_ms(20);
            FUNC_I2C_WRITE2CDMS(&data_receive,1);
  */             
            /*i2c_data * i2c_data_r = i2c_data_receive.alloc();
            i2c_data_r->data = data_receive;
            i2c_data_r->length = 1;
            i2c_data_receive.put(i2c_data_r);*/
   /*         printf("\n\r Data received from CDMS is %c \n\r",data_receive);
            FUNC_I2C_TC_EXECUTE(data_receive);                             // This has to be done from a differen thread
            
        }
        else if(i2c_status ==1)
        {
            osEvent evt = i2c_data_send.get();
            if (evt.status == osEventMail) 
            {
                i2c_data *i2c_data_s = (i2c_data*)evt.value.p;
                strcpy(data_send,i2c_data_s -> data);
                wait_ms(29);
                FUNC_I2C_WRITE2CDMS(data_send,25);
                printf("\n\rData sent to CDMS is %s\n\r",data_send);
                i2c_data_send.free(i2c_data_s);
                i2c_status = 0;
                
                
            }
        }  
           
    }
}

        
*/
/*void FUNC_I2C_INT()
{
   
   t2.start();
  // t3.start();
   ptr_t_i2c->signal_set(0x4);
   
     
}*/

void FUNC_I2C_IR2CDMS()
{ ;
/*        data_ready=0; 
        //char data[25];
        //strcpy(data,"sakthi ");
        //strcat(data,"priya");
        strcpy(hk_data,SensorQuantised.Voltage);
        strcat(hk_data,SensorQuantised.Current); 
        strcat(hk_data,SensorQuantised.Temperature); 
        strcat(hk_data,SensorQuantised.PanelTemperature);
        strcat(hk_data,SensorQuantised.AngularSpeed);
        strcat(hk_data,SensorQuantised.Bnewvalue);
        char fdata[5] = {SensorQuantised.BatteryTemperature,SensorQuantised.faultpoll,SensorQuantised.faultir,SensorQuantised.power_mode};
*/
        /*strcat(hk_data,sfaultpoll);
        strcat(hk_data,sfaultir);
        strcat(hk_data,spower_mode);*/
  /*      strcat(hk_data,fdata);
        printf("\n\rhk data : %s\n\r",hk_data);
       
        //data = pcslave.getc();
        reset =0;
        i2c_status=1;
        i2c_data * i2c_data_s = i2c_data_send.alloc();
        strcpy(i2c_data_s->data,hk_data);
        i2c_data_s->length = 25;
        i2c_data_send.put(i2c_data_s); 
        data_ready=1;
        //temp = i2c_status; */
}
    

//------------------------------------------------------------------------------------------------------------------------------------------------
//TELECOMMAND
//------------------------------------------------------------------------------------------------------------------------------------------------
void FUNC_I2C_TC_EXECUTE (char command)  
{ switch(command)
   {   case '0' : printf("command 0 executed");
       break;
       case '1' : printf("command 1 executed");
       break;
       case '2' : printf("command 2 executed");
       break;
       case '3' : printf("command 3 executed");
    }
}  
   

//------------------------------------------------------------------------------------------------------------------------------------------------
//SCHEDULER
//------------------------------------------------------------------------------------------------------------------------------------------------
int beacon_sc = 3;
uint16_t schedcount=1;
void T_SC(void const *args)
{
    //DRDY=0;
    printf("The value of i in scheduler is %d\n\r",schedcount);
    if(schedcount == 65532)                         //to reset the counter
    {
        schedcount = 0;
    }
    
    if(schedcount%1==0)
    {
     ptr_t_acs -> signal_set(0x1);
     ptr_t_wdt -> signal_set(0x5);
    }
    if(schedcount%2==0)
    {
       // ptr_t_fault -> signal_set(0x2);
       ptr_t_hk_acq -> signal_set(0x2);
        
    }
    if(schedcount%beacon_sc==0)
    {
        if(beac_flag==0)
        {
            
          ptr_t_bea -> signal_set(0x3);
        }
    }
    schedcount++;
}
    
//---------------------------------------------------------------------------------------------------------------------------------------------

int main()
{
    t1.start();
   
    //DRDY=0;
     printf("\nahoy\n");
     INIT_PNI();
     
     FUNC_ACS_MAG_INIT();
     FUNC_ACS_INIT_GYR();
     //slave.address(0x20);

    ptr_t_hk_acq = new Thread(T_HK_ACQ);
    ptr_t_acs = new Thread(T_ACS);
    //ptr_t_acs_write2flash = new Thread(T_ACS_WRITE2FLASH);
    ptr_t_bea = new Thread(T_BEA);
    //ptr_t_bea_telecommand = new Thread(T_BEA_TELECOMMAND);
    //ptr_t_fault = new Thread(T_FAULT);
 //   ptr_t_i2c = new Thread(T_I2C_BAE);
    //ptr_t_sc = new Thread(T_SC);
    ptr_t_wdt = new Thread(T_WDT);
  
    interrupt_fault();
    
    //ptr_t_fault -> set_priority(osPriorityRealtime);
    ptr_t_acs->set_priority(osPriorityAboveNormal);
    ptr_t_i2c->set_priority(osPriorityHigh);
    ptr_t_hk_acq->set_priority(osPriorityAboveNormal);
    //ptr_t_acs_write2flash->set_priority(osPriorityBelowNormal);
    ptr_t_bea->set_priority(osPriorityAboveNormal);
    //ptr_t_bea_telecommand->set_priority(osPriorityIdle);
    //ptr_t_sc->set_priority(osPriorityAboveNormal);
    ptr_t_wdt -> set_priority(osPriorityIdle);
    
  
   // ----------------------------------------------------------------------------------------------
    //printf("\n\r T_FAULT priority is %d",ptr_t_fault->get_priority()); 
    printf("\n\r T_ACS priority is %d",ptr_t_acs->get_priority());
    printf("\n\r T_HK_ACQ priority is %d",ptr_t_hk_acq->get_priority());
    //printf("\n\r T_ACS_WRITE2FLASH priority is %d",ptr_t_acs_write2flash->get_priority());
    printf("\n\r T_BEA priority is %d",ptr_t_bea->get_priority());  
    RtosTimer t_sc_timer(T_SC,osTimerPeriodic);
    t_sc_timer.start(10000);
    printf("\n\r%f\n\r",t1.read()); 
     
     
      
    //master_reset.fall(&FUNC_I2C_RESET);
   // interrupt.rise(&FUNC_I2C_INT);
       
    while(1)
    {   
        //Thread::wait(10000);
         //ir2master(); 
         //DRDY = 0;
        Thread::wait(5000);
    }
    
}
