#include "mbed.h"
#include "rtos.h"
#include "HK.h"
#include "slave.h"
#include "beacon.h"
#include "ACS.h"
#include "fault.h"
#include "slave.h"

Serial pc(USBTX, USBRX);

//extern DigitalOut DRDY;
InterruptIn interrupt(D9);
InterruptIn master_reset(D8);

int beacon_sc=3;

Timer t;                                                        //To know the time of execution each thread
Timer t1;
                                                       //To know the time of entering  of each thread
void F_HK_ACQ();
void F_ACS();
void F_BEA();





Thread *ptr_t_abh;

Thread *ptr_t_i2c;
Thread *ptr_t_wdt;  



I2CSlave slave(D14,D15);                       //configuring pins p27, p28 as I2Cslave


DigitalOut data_ready(D10);
int i2c_status=0;                                 //read/write mode for i2c 0 : write2slave, 1 : write2master
int reset=0;
int temp;

typedef struct
{
    char data[25];          // To avoid dynamic memory allocation
    int length;
}i2c_data;






//Mail<i2c_data,16> i2c_data_receive;
Mail<i2c_data,16> i2c_data_send;

//--------------------------------------------------------------------------------------------------------------------------------------------------
//ACS BEA HK togethr
//--------------------------------------------------------------------------------------------------------------------------------------------------
uint16_t tcount=1;
float *mag_field;
float *omega;
float *moment;

void T_ACS_BEA_HK(void const *args)
{
   
   while(1)
   {
        
        Thread::signal_wait(0x1);
        if(tcount == 65532)                         //to reset the counter
        {
        tcount = 0;
        }
        if(tcount%1==0)
        {
        F_ACS();
      
        }
        if(tcount%3==0)
        {
        F_BEA();
        }
        if(tcount%2==0)
        {
        F_HK_ACQ();
        }
        tcount++;
   } 
}

//--------------------------------------------------------------------------------------------------------------------------------------------------
//TASK 2 : HK
//--------------------------------------------------------------------------------------------------------------------------------------------------

char hk_data[25];
extern SensorDataQuantised SensorQuantised;
void F_HK_ACQ()
{
        
        SensorQuantised.power_mode='3';
        printf("\nTHIS IS HK    %f\n",t1.read());
        t.start();
        FUNC_HK_FAULTS();
        FUNC_HK_POWER(SensorQuantised.power_mode);                                                   //The power mode algorithm is yet to be obtained
        FUNC_HK_MAIN();                                                             //Collecting HK data
        //thread_2.signal_set(0x4);
        //FUNC_I2C_SLAVE_MAIN(25);    
        FUNC_I2C_IR2CDMS();
        t.stop();
        printf("The time to execute hk_acq is %f seconds\n",t.read());
        t.reset();
    
}

//---------------------------------------------------------------------------------------------------------------------------------------
//TASK 1 : ACS
//---------------------------------------------------------------------------------------------------------------------------------------

int acs_pflag = 1;
void F_ACS()
{
       
        printf("\nTHIS IS ACS   %f\n",t1.read());
        t.start();
        mag_field= FUNC_ACS_MAG_EXEC();                              //actual execution
        omega = FUNC_ACS_EXEC_GYR();
        printf("\n gyr 1 value %f",omega[0]);
        
        
        if(acs_pflag == 1)
        {
        moment = FUNC_ACS_CNTRLALGO(mag_field,omega);
        FUNC_ACS_GENPWM(moment);                     
        }
       
        t.reset();

}
/*
void T_ACS_WRITE2FLASH(void const *args)
{
    while(1)
    {
        //printf("Writing in the flash\n");
        osEvent evt = q_acs.get();
        if(evt.status == osEventMail)
        {
            sensor_data *ptr = (sensor_data*)evt.value.p;
            FUNC_ACS_WRITE2FLASH(ptr);
            q_acs.free(ptr);
        }
        printf("Writing acs data in the flash\n");
    }
}

*/
//---------------------------------------------------BEACON--------------------------------------------------------------------------------------------

int beac_flag=0;                                                            //To receive telecommand from ground.


/*void T_BEA_TELECOMMAND(void const *args)
{
    char c = pc.getc();
    if(c=='a')
    {
        printf("Telecommand detected\n");
        beac_flag=1;
    }
}
*/

void F_BEA()
{
        printf("\nTHIS IS BEACON    %f\n",t1.read());
        t.start();
        
        
            
        FUNC_BEA();
            
        
        if(beac_flag==1)
        {
            Thread::wait(600000);
            beac_flag = 0;
        }
        
        printf("The time to execute beacon thread is %f seconds\n",t.read());
        t.reset();
}

//---------------------------------------------------------------------------------------------------------------------------------------------------
//TASK 4 : FAULT MANAGEMENT
//---------------------------------------------------------------------------------------------------------------------------------------------------
//Dummy fault rectifier functions

/*Mail<int,16> faults;

void FUNC_FAULT_FUNCT1()
{
    printf("\nFault 1 detected... \n");
}

void FUNC_FAULT_FUNCT2()
{
    printf("\nFault 2 detected...\n");
}

void T_FAULT(void const *args)
{
    while(1)
    {
        osEvent evt = faults.get();
        if(evt.status==osEventMail)
        {
            int *fault_id= (int *)evt.value.p;
            switch(*fault_id)
            {
                case 1: FUNC_FAULT_FUNCT1();
                        break;
                case 2: FUNC_FAULT_FUNCT2();
                        break;
            }
            faults.free(fault_id);
        }
    }
}*/

extern SensorDataQuantised SensorQuantised;


/*void T_FAULT(void const *args)
{   
    Sensor.power_mode='0';
    while(1)
    {
        Thread :: signal_wait(0x2);
        FAULTS();
        POWER(Sensor.power_mode);
        //Sensor.power_mode++;            //testing ... should be removed
    }    
}
*/
/*-------------------------------------------------------------------------------------------------------------------------------------------
-------------------------------------------------------WATCHDOG----------------------------------------------------------------------------*/
DigitalOut trigger(PIN63);                                             // has to be changed
void T_WDT(void const * args)
{
    trigger = 1;
    while(true)
    {
        Thread::signal_wait(0x5);                               //signal set from scheduler or sthing. r RTOS timer nce the timing is finalized
        printf("\nEntered WD\n");
        trigger = !trigger;
    }
}

//---------------------------------------------------------------------------------------------------------------------------------------------------
//TASK 5 : i2c data
//---------------------------------------------------------------------------------------------------------------------------------------------------






void FUNC_I2C_WRITE2CDMS(char *data, int length=1)
{
       int slave_status = 1;
   
    while(slave_status && interrupt == 1)
    {                 
            slave.address(0x20);
            if(slave.receive()==1)
            {
                slave_status=slave.write(data,length);
               
                
            }
            else if(slave.receive()==3 || slave.receive()==2)
            {
                slave_status=slave.read(data,length);
            }
            
    }
            
            printf("\ndone\n\r");

}
char data_send[25],data_receive;
void T_I2C_BAE(void const * args)
{
     //char data_send,data_receive;
    while(1)
    {
        Thread::signal_wait(0x4);
        //T_I2C_BAE();
        //i2c_status = temp;
        //wait(0.5);
        printf("\n entered thread   %d\n\r",i2c_status);
        if(i2c_status == 0 )
        {
            
            FUNC_I2C_WRITE2CDMS(&data_receive,1);
            printf("\n received\n");
            /*i2c_data * i2c_data_r = i2c_data_receive.alloc();
            i2c_data_r->data = data_receive;
            i2c_data_r->length = 1;
            i2c_data_receive.put(i2c_data_r);*/
            printf("\n Data received from CDMS is %c \n\r",data_receive);
            FUNC_I2C_TC_EXECUTE(data_receive);                             // This has to be done from a differen thread
            
        }
        else if(i2c_status ==1)
        {
            osEvent evt = i2c_data_send.get();
            if (evt.status == osEventMail) 
            {
                i2c_data *i2c_data_s = (i2c_data*)evt.value.p;
                strcpy(data_send,i2c_data_s -> data);
                FUNC_I2C_WRITE2CDMS(data_send,25);
                printf("\nData sent to CDMS is %s\n\r",data_send);
                i2c_data_send.free(i2c_data_s);
                i2c_status = 0;
                //temp = i2c_status;
                
            }
        }  
           
    }
}

        

void FUNC_I2C_INT()
{
   reset = 0;
   ptr_t_i2c->signal_set(0x4);
   
     
}





void FUNC_I2C_IR2CDMS()
{
        
        //char data[25];
        //strcpy(data,"sakthi ");
        //strcat(data,"priya");
        strcpy(hk_data,SensorQuantised.Voltage);
        strcat(hk_data,SensorQuantised.Current); 
        strcat(hk_data,SensorQuantised.Temperature); 
        strcat(hk_data,SensorQuantised.PanelTemperature);
        strcat(hk_data,SensorQuantised.AngularSpeed);
        strcat(hk_data,SensorQuantised.Bnewvalue);
        char fdata[5] = {SensorQuantised.BatteryTemperature,SensorQuantised.faultpoll,SensorQuantised.faultir,SensorQuantised.power_mode};

        /*strcat(hk_data,sfaultpoll);
        strcat(hk_data,sfaultir);
        strcat(hk_data,spower_mode);*/
        strcat(hk_data,fdata);
        printf("\nhk data : %s\n",hk_data);
        data_ready=0;
        //data = pcslave.getc();
        reset =0;
        i2c_status=1;
        i2c_data * i2c_data_s = i2c_data_send.alloc();
        strcpy(i2c_data_s->data,hk_data);
        i2c_data_s->length = 25;
        i2c_data_send.put(i2c_data_s); 
        data_ready=1;
        //temp = i2c_status;
}
      

//------------------------------------------------------------------------------------------------------------------------------------------------
//TELECOMMAND
//------------------------------------------------------------------------------------------------------------------------------------------------
void FUNC_I2C_TC_EXECUTE (char command)  
{ switch(command)
   {   case '0' : printf("command 0 executed");
       break;
       case '1' : printf("command 1 executed");
       break;
       case '2' : printf("command 2 executed");
       break;
       case '3' : printf("command 3 executed");
    }
}  
   

//------------------------------------------------------------------------------------------------------------------------------------------------
//SCHEDULER
//------------------------------------------------------------------------------------------------------------------------------------------------

void T_SC(void const *args)
{
        ptr_t_abh -> signal_set(0x1);
        ptr_t_wdt -> signal_set(0x5);

}
    
//---------------------------------------------------------------------------------------------------------------------------------------------

int main()
{
    t1.start();
    //DRDY=0;
     FUNC_ACS_MAG_INIT();
     FUNC_ACS_INIT_GYR();

    ptr_t_abh = new Thread(T_ACS_BEA_HK);
    ptr_t_i2c = new Thread(T_I2C_BAE);
    ptr_t_wdt = new Thread(T_WDT);
  
    interrupt_fault();
    
    //ptr_t_fault -> set_priority(osPriorityRealtime);
    ptr_t_abh->set_priority(osPriorityAboveNormal);
    ptr_t_i2c->set_priority(osPriorityHigh);
    //ptr_t_hk_acq->set_priority(osPriorityAboveNormal);
    //ptr_t_acs_write2flash->set_priority(osPriorityBelowNormal);
    //ptr_t_bea->set_priority(osPriorityAboveNormal);
    //ptr_t_bea_telecommand->set_priority(osPriorityIdle);
    //ptr_t_sc->set_priority(osPriorityAboveNormal);
    ptr_t_wdt -> set_priority(osPriorityIdle);
    
  
   // ----------------------------------------------------------------------------------------------
    printf("\n T_WDT priority is %d",ptr_t_wdt->get_priority()); 
    printf("\n T_T_ACS_BEA_HK priority is %d",ptr_t_abh->get_priority());
    //printf("\n T_HK_ACQ priority is %d",ptr_t_hk_acq->get_priority());
    //printf("\n T_ACS_WRITE2FLASH priority is %d",ptr_t_acs_write2flash->get_priority());
    printf("\n T_I2C priority is %d",ptr_t_i2c->get_priority());  
    RtosTimer t_sc_timer(T_SC,osTimerPeriodic);
    t_sc_timer.start(10000);
    printf("\n%f\n",t1.read()); 
     
     
      
    //master_reset.fall(&FUNC_I2C_RESET);
    interrupt.rise(&FUNC_I2C_INT);
       
    while(1)
    {   
        ;
       
    }
    
}
