
//to be saved as HK.h

#include "mbed.h"
#define tstart -40
#define tstep 8
#define tstep_thermistor 8//verify!!
#define tstart_thermistor -40
#define vstart 3.3
#define vstep 0.84667
#define cstart 0.0691
#define cstep 0.09133
#define rsens 0.095
 
struct SensorData {
    char Voltage[10];
    char Current[10];
    char Temperature[10];
    char PanelTemperature[2];//read by the 4 thermistors on solar panels
    char Vcell;//unquantised
    char soc;//unquantised
    char alerts;//UNQUANTISED
    //(alerts[0]=1)-> reset indicator=>dont care
    //(alerts[1]=1)-> Vcell>ValrtMax(5.1V)->will always be on->dont care
    //(alerts[2]=1)-> Vcell<ValrtMin(5.1V)->indicates deep discharge
    //(alerts[3]=1)-> Vcell<Vreset(2.5V)
    //(alerts[5]=1)-> Soc CROSSES the threshold value
    //(alerts[6]=1)-> alert on (alerts[3]) enabled when Vcell<Vreset(here we set it to be 2.5V)
    char crate;//unquantised
    char faultpoll;             //polled faults
    char faultir;               //interupted faults
    char power_mode;            //power modes

    
    //float magnetometer,gyro=>to be addes
};
 
typedef struct ShortBeacon {
    char Voltage[1];                            //battery voltage from gauge
    char AngularSpeed[2];                       //all the 3 data
    char SubsystemStatus[1];                    //power modes
    char Temp[3];                               //temp of solar panel
    char ErrorFlag[1];                          //fault
}ShortBeacy; 
 
 
 
void FUNC_HK_MAIN();
 
int quantiz(float start,float step,float x);


//--------------------------------following is header details for battery gauge-------------------------------------------



#define MAX17048_H
 
class MAX17048
{
public:
    /** The default compensation value for the MAX17048
     */
    static const char RCOMP0= 0x97;
 
    /** Represents the different alert flags for the MAX17048
     */
    enum AlertFlags {
        ALERT_RI = (1 << 0),  /**< Reset indicator */
        ALERT_VH = (1 << 1),  /**< Voltage high alert */
        ALERT_VL = (1 << 2),  /**< Voltage low alert */
        ALERT_VR = (1 << 3),  /**< Voltage reset alert */
        ALERT_HD = (1 << 4),  /**< SOC low alert */
        ALERT_SC = (1 << 5)   /**< SOC change alert */
    };
 
    //parametrised constructor
    MAX17048(PinName sda, PinName scl, int hz = 400000): m_I2C(sda, scl)//should it be same as the uC clock freq
    {
        //Set the I2C bus frequency
        m_I2C.frequency(hz);
    }
 
    // Probe for the MAX17048 and indicate if it's present on the bus
    bool open()
     {
        //Probe for the MAX17048 using a Zero Length Transfer
        if (!m_I2C.write(m_ADDR, NULL, 0)) {
            //Return success
            return true;
        } else {
            //Return failure
            return false;
        }
    }
 
 
    // Command the MAX17048 to perform a power-on reset
    void reset()
    {
        //Write the POR command
        write(REG_CMD, 0x5400);
    }
    
    // Command the MAX17048 to perform a QuickStart
     void quickStart()
    {
        //Read the current 16-bit register value
        unsigned short value = read(REG_MODE);
 
        //Set the QuickStart bit
        value |= (1 << 14);
 
        //Write the value back out
        write(REG_MODE, value);
    }
    
   //disable sleep
   void disable_sleep()
    {
        unsigned short value = read(REG_MODE);
        value &= ~(1 << 13);
        write(REG_MODE, value);
    }
  
    //disable the hibernate  of the MAX17048
    void disable_hibernate()
    {
        write(REG_HIBRT, 0x0000);
    }
  
    // Determine whether or not the SOC 1% change alert is enabled on the MAX17048
    bool socChangeAlertEnabled()
    {
        //Read the 16-bit register value
        unsigned short value = read(REG_CONFIG);
 
        //Return the status of the ALSC bit
        if (value & (1 << 6))
            return true;
        else
            return false;
    }
    
    // Enable or disable the SOC 1% change alert on the MAX17048
    void socChangeAlertEnabled(bool enabled)
    {
        //Read the current 16-bit register value
        unsigned short value = read(REG_CONFIG);
 
        //Set or clear the ALSC bit
        if (enabled)
            value |= (1 << 6);
        else
            value &= ~(1 << 6);
 
        //Write the value back out
        write(REG_CONFIG, value);
} 

    // Determine whether or not the MAX17048 is asserting the ALRT pin
    bool alerting()
    {
        //Read the 16-bit register value
        unsigned short value = read(REG_CONFIG);
 
        //Return the status of the ALRT bit
        if (value & (1 << 5))
            return true;
        else
            return false;
    }
    
    // Command the MAX17048 to de-assert the ALRT pin
    void clearAlert()
    {
        //Read the current 16-bit register value
        unsigned short value = read(REG_CONFIG);
 
        //Clear the ALRT bit
        value &= ~(1 << 5);
 
        //Write the value back out
        write(REG_CONFIG, value);
    }
     // return The current SOC empty alert threshold in %.
    char emptyAlertThreshold()
    {
        //Read the 16-bit register value
        unsigned short value = read(REG_CONFIG);
 
        //Extract the threshold
        return 32 - (value & 0x001F);
    }
 
    //Set the SOC empty alert threshold of the MAX17048
    void emptyAlertThreshold(char threshold)
    {
        //Read the current 16-bit register value
        unsigned short value = read(REG_CONFIG);
 
        //Update the register value
        value &= 0xFFE0;
        value |= 32 - threshold;
 
        //Write the 16-bit register
        write(REG_CONFIG, value);
    }
    //return The current low voltage alert threshold in volts.
    float vAlertMinThreshold()
    {
        //Read the 16-bit register value
        unsigned short value = read(REG_VALRT);
 
        //Extract the alert threshold
        return (value >> 8) * 0.02;//least count is 20mV
    }
    // Set the low and high voltage alert threshold of the MAX17048
    void vAlertMinMaxThreshold()
    {
        //Read the current 16-bit register value
        unsigned short value = read(REG_VALRT);
 
        //Mask off the old value
    
                value = 0xFFFF;
     
        //Write the 16-bit register
        write(REG_VALRT, value);
    }
 
    //return The current high voltage alert threshold in volts.
    float vAlertMaxThreshold()
    {
        //Read the 16-bit register value
        unsigned short value = read(REG_VALRT);
 
        //Extract the active threshold
        return (value & 0x00FF) * 0.02;
    }
    
    //return The current reset voltage threshold in volts.
     float vResetThreshold()
    {
        //Read the 16-bit register value
        unsigned short value = read(REG_VRESET_ID);
 
        //Extract the threshold
        return (value >> 9) * 0.04;
    }
    
    // Set the reset voltage threshold of the MAX17048
    void vResetThresholdSet()
    {
        //Read the current 16-bit register value
        unsigned short value = read(REG_VRESET_ID);
 
        //Mask off the old //value
        value &= 0x00FF;//Dis=0
 
        value |= 0x7C00;//corresponding to 2.5 V
    
 
        //Write the 16-bit register
        write(REG_VRESET_ID, value);
    }
    
    // Get the factory programmed 8-bit ID of the MAX17048
     char id()
    {
        //Read the 16-bit register value
        unsigned short value = read(REG_VRESET_ID);
 
        //Return only the ID bits
        return value;
    }
    
    // Determine whether or not the voltage reset alert is enabled on the MAX17048
    bool vResetAlertEnabled()
    {
        //Read the 16-bit register value
        unsigned short value = read(REG_STATUS);
 
        //Return the status of the EnVR bit
        if (value & (1 << 14))
            return true;
        else
            return false;
    }
    
    // Enable or disable the voltage reset alert on the MAX17048
     void vResetAlertEnabled(bool enabled)
    {
        //Read the current 16-bit register value
        unsigned short value = read(REG_STATUS);
    
        //Set or clear the EnVR bit
        if (enabled)
            value |= (1 << 14);
        else
            value &= ~(1 << 14);
 
        //Write the value back out
        write(REG_STATUS, value);
    }
 
    //Get the current alert flags on the MAX17048
    //refer datasheet-status registers section to decode it.
    char alertFlags()
    {
        //Read the 16-bit register value
        unsigned short value = read(REG_STATUS);
 
        //Return only the flag bits
        return (value >> 8) & 0x3F;
    }
    
    // Clear all the alert flags on the MAX17048
    void clearAlertFlags()
    {
        //Read the current 16-bit register value
        unsigned short value = read(REG_STATUS);
 
        //Clear the specified flag bits
        value &= ~( 0x3F<< 8);
 
        //Write the value back out
        write(REG_STATUS, value);
    }
    
    // Get the current cell voltage measurement of the MAX17048
    float vcell()
    {
        //Read the 16-bit raw Vcell value
        unsigned short value = read(REG_VCELL);
 
        //Return Vcell in volts
        return value * 0.000078125;
    }
    
    // Get the current state of charge measurement of the MAX17048 as a float
    float soc()
    {
        //Read the 16-bit raw SOC value
        unsigned short value = read(REG_SOC);
 
        //Return SOC in percent
        return value * 0.00390625;
    }
    
    // Get the current state of charge measurement of the MAX17048 as an int
    int soc_int()
    {
        //Read the 16-bit raw SOC value
        unsigned short value = read(REG_SOC);
 
        //Return only the top byte
        return value >> 8;
    }
 
    // Get the current C rate measurement of the MAX17048
    float crate()
    {
        //Read the 16-bit raw C/Rate value
        short value = read(REG_CRATE);
 
        //Return C/Rate in %/hr
        return value * 0.208;
    }


    //I2C register addresses
    enum Register {
        REG_VCELL       = 0x02,
        REG_SOC         = 0x04,
        REG_MODE        = 0x06,
        REG_VERSION     = 0x08,
        REG_HIBRT       = 0x0A,
        REG_CONFIG      = 0x0C,
        REG_VALRT       = 0x14,
        REG_CRATE       = 0x16,
        REG_VRESET_ID   = 0x18,
        REG_STATUS      = 0x1A,
        REG_TABLE       = 0x40,
        REG_CMD         = 0xFE
    };
 
    //Member constants
    static const int m_ADDR=(0x36 << 1);
 
    //Member variables
    I2C m_I2C;
 
    //Internal functions
    unsigned short read(char reg)
    {
        //Create a temporary buffer
        char buff[2];
 
        //Select the register
        m_I2C.write(m_ADDR, &reg, 1, true);
 
        //Read the 16-bit register
        m_I2C.read(m_ADDR, buff, 2);
 
        //Return the combined 16-bit value
        return (buff[0] << 8) | buff[1];
    }
 
    
    void write(char reg, unsigned short data)
    {
        //Create a temporary buffer
        char buff[3];
 
        //Load the register address and 16-bit data
        buff[0] = reg;
        buff[1] = data >> 8;
        buff[2] = data;
 
        //Write the data
        m_I2C.write(m_ADDR, buff, 3);
    }
};
 

 void FUNC_BATTERYGAUGE_MAIN(float[]);

 