#include "mbed.h"
#include "rtos.h"
#include "HK.h"
#include "slave.h"
#include "beacon.h"
#include "ACS.h"
#include "fault.h"
#include "slave.h"

Serial pc(USBTX, USBRX);

InterruptIn interrupt(D9);
InterruptIn master_reset(D11);


Timer t;                                                        //To know the time of execution each thread
Timer t1;
                                                       //To know the time of entering  of each thread

Thread *ptr_t_hk_acq;
Thread *ptr_t_acs;
Thread *ptr_t_acs_write2flash;
Thread *ptr_t_bea;
Thread *ptr_t_bea_telecommand;
Thread *ptr_t_fault;
Thread *ptr_t_i2c;

//--------------------------------------------------------------------------------------------------------------------------------------------------
//TASK 2 : HK
//--------------------------------------------------------------------------------------------------------------------------------------------------



void t_hk_acq(void const *args)
{
    
    while(1)
    {
        Thread::signal_wait(0x2);
        
        printf("\nTHIS IS HK    %f\n",t1.read());
        t.start();
        
        FUNC_HK_MAIN();                                                             //Collecting HK data
        //thread_2.signal_set(0x4);
        //FUNC_I2C_SLAVE_MAIN(24);                                                    //Sending to CDMS via I2C
        
        t.stop();
        printf("The time to execute hk_acq is %f seconds\n",t.read());
        t.reset();
    }
}

//---------------------------------------------------------------------------------------------------------------------------------------
//TASK 1 : ACS
//---------------------------------------------------------------------------------------------------------------------------------------
typedef struct {
    float mag_field;
    float omega;
    } sensor_data;
    
Mail <sensor_data, 16> q_acs;
    
void func_acs_readdata(sensor_data *ptr)
{
    printf("Reading the data\n");
    ptr -> mag_field = 10;
    ptr -> omega = 3;
}

void func_acs_ctrlalgo()
{
    printf("Executing control algo\n");
}



void func_acs_write2flash(sensor_data *ptr2)
{
    printf("The magnetic field is %.2f T\n\r",ptr2->mag_field);
    printf("The angular velocity is %.2f rad/s\n\r",ptr2->omega);
}

int acs_pflag = 1;
void t_acs(void const *args)
{
    while(1)
    {
        Thread::signal_wait(0x1);
        printf("\nTHIS IS ACS   %f\n",t1.read());
        t.start();
        sensor_data *ptr = q_acs.alloc();
        
        func_acs_readdata(ptr);
        //printf("\ngdhd\n");
        q_acs.put(ptr);
        if(acs_pflag == 1)
        {
        func_acs_ctrlalgo();
        FUNC_ACS_GENPWM();                                      //Generating PWM signal.
        }
       
        t.reset();
    }
}

void t_acs_write2flash(void const *args)
{
    while(1)
    {
        //printf("Writing in the flash\n");
        osEvent evt = q_acs.get();
        if(evt.status == osEventMail)
        {
            sensor_data *ptr = (sensor_data*)evt.value.p;
            func_acs_write2flash(ptr);
            q_acs.free(ptr);
        }
        printf("Writing acs data in the flash\n");
    }
}


//---------------------------------------------------BEACON--------------------------------------------------------------------------------------------

int beac_flag=0;                                                            //To receive telecommand from ground.


void t_bea_telecommand(void const *args)
{
    char c = pc.getc();
    if(c=='a')
    {
        printf("Telecommand detected\n");
        beac_flag=1;
    }
}

void t_bea(void const *args)
{
    
    while(1)
    {
        Thread::signal_wait(0x3);
        printf("\nTHIS IS BEACON    %f\n",t1.read());
        t.start();
        
        
            
        FUNC_BEA();
            
        
        if(beac_flag==1)
        {
            Thread::wait(600000);
            beac_flag = 0;
        }
        
        printf("The time to execute beacon thread is %f seconds\n",t.read());
        t.reset();
    }
}

//---------------------------------------------------------------------------------------------------------------------------------------------------
//TASK 4 : FAULT MANAGEMENT
//---------------------------------------------------------------------------------------------------------------------------------------------------
//Dummy fault rectifier functions

/*Mail<int,16> faults;

void FUNC_FAULT_FUNCT1()
{
    printf("\nFault 1 detected... \n");
}

void FUNC_FAULT_FUNCT2()
{
    printf("\nFault 2 detected...\n");
}

void T_FAULT(void const *args)
{
    while(1)
    {
        osEvent evt = faults.get();
        if(evt.status==osEventMail)
        {
            int *fault_id= (int *)evt.value.p;
            switch(*fault_id)
            {
                case 1: FUNC_FAULT_FUNCT1();
                        break;
                case 2: FUNC_FAULT_FUNCT2();
                        break;
            }
            faults.free(fault_id);
        }
    }
}*/

extern SensorData Sensor;


void T_FAULT(void const *args)
{   
    Sensor.power_mode='0';
    while(1)
    {
        Thread :: signal_wait(0x2);
        FAULTS();
        POWER(Sensor.power_mode);
        //Sensor.power_mode++;            //testing ... should be removed
    }    
}

//---------------------------------------------------------------------------------------------------------------------------------------------------
//TASK 5 : i2c data
//---------------------------------------------------------------------------------------------------------------------------------------------------

 
void C_FUNC_INT()
{
   FUNC_INT();
   ptr_t_i2c->signal_set(0x4);
     
}

void C_FUNC_RESET()
{
    FUNC_RESET();
}


void C_T_I2C_BAE(void const * args)
{
    //char data_send,data_receive;
    while(1)
    {
        Thread::signal_wait(0x4);
        T_I2C_BAE();
        //i2c_status = temp;
        //wait(0.5);
        /*printf("\n entered thread\n\r");
        if(i2c_status == 0 && reset !=1)
        {
            
            FUNC_I2C_WRITE2CDMS(&data_receive);
            i2c_data * i2c_data_r = i2c_data_receive.alloc();
            i2c_data_r->data = data_receive;
            i2c_data_r->length = 1;
            i2c_data_receive.put(i2c_data_r);
            printf("\n Data received from CDMS is %c\n\r",data_receive);
            i2c_data_receive.free(i2c_data_r);                              // This has to be done from a differen thread
            
        }
        else if(i2c_status ==1 && reset !=1)
        {
            osEvent evt = i2c_data_send.get();
            if (evt.status == osEventMail) 
            {
                i2c_data *i2c_data_s = (i2c_data*)evt.value.p;
                data_send = i2c_data_s -> data;
                FUNC_I2C_WRITE2CDMS(&data_send);
                printf("\nData sent to CDMS is %c\n\r",data_send);
                i2c_data_send.free(i2c_data_s);
                i2c_status = 0;
                //temp = i2c_status;
            }
        }  
          */ 
    }
}






//------------------------------------------------------------------------------------------------------------------------------------------------
//SCHEDULER
//------------------------------------------------------------------------------------------------------------------------------------------------
int beacon_sc = 3;
uint16_t schedcount=1;
void t_sc(void const *args)
{
    
    printf("The value of i in scheduler is %d\n",schedcount);
    if(schedcount == 65532)                         //to reset the counter
    {
        schedcount = 0;
    }
    
    if(schedcount%1==0)
    {
        ptr_t_acs -> signal_set(0x1);
    }
    if(schedcount%2==0)
    {
        ptr_t_fault -> signal_set(0x2);
        ptr_t_hk_acq -> signal_set(0x2);
        
    }
    if(schedcount%beacon_sc==0)
    {
        if(beac_flag==0)
        {
            
            ptr_t_bea -> signal_set(0x3);
        }
    }
    schedcount++;
}
    
//---------------------------------------------------------------------------------------------------------------------------------------------

int main()
{
    t1.start();
    
    ptr_t_hk_acq = new Thread(t_hk_acq);
    ptr_t_acs = new Thread(t_acs);
    ptr_t_acs_write2flash = new Thread(t_acs_write2flash);
    ptr_t_bea = new Thread(t_bea);
    ptr_t_bea_telecommand = new Thread(t_bea_telecommand);
    ptr_t_fault = new Thread(T_FAULT);
    ptr_t_i2c = new Thread(C_T_I2C_BAE);
    //ptr_t_sc = new Thread(t_sc);
  
    interrupt_fault();
    
    ptr_t_fault -> set_priority(osPriorityRealtime);
    ptr_t_acs->set_priority(osPriorityHigh);
    ptr_t_i2c->set_priority(osPriorityAboveNormal);
    ptr_t_hk_acq->set_priority(osPriorityNormal);
    ptr_t_acs_write2flash->set_priority(osPriorityBelowNormal);
    ptr_t_bea->set_priority(osPriorityAboveNormal);
    ptr_t_bea_telecommand->set_priority(osPriorityIdle);
    //ptr_t_sc->set_priority(osPriorityAboveNormal);
    
  
   // ----------------------------------------------------------------------------------------------
    printf("\n T_FAULT priority is %d",ptr_t_fault->get_priority()); 
    printf("\n T_ACS priority is %d",ptr_t_acs->get_priority());
    printf("\n T_HK_ACQ priority is %d",ptr_t_hk_acq->get_priority());
    printf("\n T_ACS_WRITE2FLASH priority is %d",ptr_t_acs_write2flash->get_priority());
    printf("\n T_BEA priority is %d",ptr_t_bea->get_priority());  
    RtosTimer t_sc_timer(t_sc,osTimerPeriodic);
    t_sc_timer.start(10000);
    printf("\n%f\n",t1.read()); 
     
     
      
    master_reset.fall(&C_FUNC_RESET);
    interrupt.rise(&C_FUNC_INT);
       
    while(1)
    {   
        //Thread::wait(10000);
         ir2master(); 
    }
    
}