#include "mbed.h"
#include "Encoder.h"
#include "prime.h"

 
//STM mbed bug: these macros are MISSING from stm32f3xx_hal_tim.h
#ifdef TARGET_STM32F3
#define __HAL_TIM_GET_COUNTER(__HANDLE__) ((__HANDLE__)->Instance->CNT)
#define __HAL_TIM_IS_TIM_COUNTING_DOWN(__HANDLE__)            (((__HANDLE__)->Instance->CR1 &(TIM_CR1_DIR)) == (TIM_CR1_DIR))
#endif
 

Serial pc(SERIAL_TX, SERIAL_RX);

DigitalOut right_v(PC_7);

int main()
{
    initmotor();
    
    right_v = 1;

    TIM_Encoder_InitTypeDef encoder1, encoder2;
    TIM_HandleTypeDef  timer1,  timer2;


    //counting on A-input only, 2 ticks per cycle, rolls over at 100
    EncoderInit(&encoder1, &timer1, TIM1, 99, TIM_ENCODERMODE_TI1);

    //counting on both A&B inputs, 4 ticks per cycle, full 32-bit count
    EncoderInit(&encoder2, &timer2, TIM2, 0xffffffff, TIM_ENCODERMODE_TI12);

    pc.printf("STM HAL encoder demo\n\r");
    
    while(1) {
        uint16_t count1=0;
        uint32_t count2=0;
        int8_t dir1, dir2;
 
        
        //OK 401 411 446 TICKER 030
        //count1=TIM1->CNT;
        //dir1=TIM1->CR1&TIM_CR1_DIR;
        count1=__HAL_TIM_GET_COUNTER(&timer1);
        dir1 = __HAL_TIM_IS_TIM_COUNTING_DOWN(&timer1);
 
        //OK 401 411 446 NOK 030
        //count2=TIM2->CNT;
        //dir2=TIM2->CR1&TIM_CR1_DIR;
        count2=__HAL_TIM_GET_COUNTER(&timer2);
        dir2 = __HAL_TIM_IS_TIM_COUNTING_DOWN(&timer2);
 
        move(15,15);
        pc.printf("%d%s %d%s %d%s %d%s\r\n", count1, dir1==0 ? "+":"-",
                                             count2, dir2==0 ? "+":"-");
        wait(0.5);
    }
}
