#include "mbed.h"
#include "move.h"
#include "locate.h"
#include "stdlib.h"

PwmOut M1cw(PA_11);
PwmOut M1ccw(PB_15);
PwmOut M2ccw(PB_14);
PwmOut M2cw(PB_13);

DigitalOut green (PC_2);
DigitalOut yellow(PC_3);
DigitalOut red   (PC_0);

/*
DigitalOut teamledblue(PC_10);
DigitalOut teamledred(PC_12);
*/

Serial pc2(SERIAL_TX, SERIAL_RX);    //pcと通信


//const int allowlength=5;
//const float allowdegree=0.02;
const int rightspeed=70;
const int leftspeed=rightspeed + 3;
const int turnspeed=30*2;
const int hosei_turnspeed = 13;
const float k = 1;//P制御の係数。大きくすれば動きが大きくなる、小さくするとあまり変化しない。要はｋはP制御の感度を表す係数です。
const int k_theta = 2;
const int max_disorder = 4;
//const float PIfact=2.89;


void initmotor()
{
    M1cw.period_us(256);
    M1ccw.period_us(256);
    M2cw.period_us(256);
    M2ccw.period_us(256);

}

void move(int left,int right)
{

    float rightduty,leftduty;

    if(right>256) {
        right=256;
    }
    if(left>256) {
        left=256;
    }
    if(right<-256) {
        right=-256;
    }
    if(left<-256) {
        left=-256;
    }

    rightduty=right/256.0;
    leftduty=left/256.0;
    if(right>0) {
        M1cw.write(1-rightduty);
        M1ccw.write(1);
    } else {
        M1cw.write(1);
        M1ccw.write(1+rightduty);
    }

    if(left>0) {
        M2cw.write(1-leftduty);
        M2ccw.write(1);
    } else {
        M2cw.write(1);
        M2ccw.write(1+leftduty);
    }
}

void hosei_turn(float pt, bool cw, float rad)
{
    int np;
    if(cw) np = 1;
    else   np = -1;
    while(1) {
        update();
        //pc.printf("t:%f\n\r", coordinateTheta());
        if(pt-coordinateTheta() < np * rad - ALLOW_RAD) {
            move(-hosei_turnspeed, hosei_turnspeed);
        } else if(pt-coordinateTheta() > np * rad + ALLOW_RAD) {
            move(hosei_turnspeed, -hosei_turnspeed);
        } else {
            move(0,0);
            return;
        }
    }

}

void turn_abs_rad(float rad)
{
    green = 1;

    update();

    int np;
    if(coordinateTheta() > rad) np = 1;
    else if(coordinateTheta() < rad) np = -1;
    else return;

    move((-np)*(turnspeed+2), (np)*turnspeed);

    while(1) {
        update();
        //pc.printf("t:%f\n\r", coordinateTheta());
        if(rad - 0.2 < coordinateTheta() && coordinateTheta() < rad + 0.2) {
            move(0,0);
            break;
        }
    }



    hosei_turn(0, false, rad);

    wait(0.5);

    hosei_turn(0, false, rad);

    wait(0.5);
    green = 0;

}

void pmove(int x, int y)
{
    yellow = 1;

    float k = 0.9;//ズレ(mm)を回転数に反映させる比例定数

    int   k_theta = 2;//ズレ(rad)を回転数に反映させる比例定数

    int length, dx, dy;
    int *d_length, *disorder;
    int absd_length;
    float dtheta, ptheta;
    float daikei;

    int direction;
    
    if(abs(x - coordinateX()) > abs(y - coordinateY())) {
        y = coordinateY();
        direction = X_PLUS;
        length = abs(x - coordinateX());
        d_length = &dx;
        disorder = &dy;
    } else {
        x = coordinateX();
        direction = Y_PLUS;
        length = abs(y - coordinateY());
        d_length = &dy;
        disorder = &dx;
    }
    
    update();
    dx = x - coordinateX();
    dy = y - coordinateY();
    
    if(*d_length < 0)   //x,y減少方向なら、*d_length<0
        direction *= -1;

    pc2.printf("direction:%d", direction);

    switch(direction) {
        case X_PLUS:
            ptheta = 0;
            break;
        case Y_PLUS:
            k *= -1;
            ptheta = PI/2;
            break;
        case X_MINUS:
            k *= -1;
            ptheta = PI;
            break;
        case Y_MINUS:
            ptheta = -PI/2;
            break;
        default:
            return;
    }
    
    ptheta += nearPi(coordinateTheta() - ptheta);
    
    turn_abs_rad(ptheta);

    if(length == 0) return;

    while(1) {
        update();
        dx = x - coordinateX();
        dy = y - coordinateY();
        dtheta = coordinateTheta() - ptheta;

        if(*disorder>max_disorder) {
            *disorder = max_disorder;
        } else if(*disorder<-max_disorder) {
            *disorder = -max_disorder;
        }

        absd_length = abs(*d_length);

        if(absd_length < 300) {
            daikei = absd_length / 300.0;
        } else if(absd_length > length - 30) {
            daikei = abs(length - absd_length) / 30.0;
        } else
            daikei = 1;

        move(daikei * (rightspeed*6/7.0 + k*(*disorder) - k_theta*dtheta) + rightspeed/7.0,
             daikei * (leftspeed*6/7.0  - k*(*disorder) + k_theta*dtheta) + leftspeed/7.0);

        //pc2.printf("d_length:%d disorder:%d rs:%f ls:%f daikei:%f\n\r", *d_length, *disorder, k*(*disorder) - k_theta*dtheta, -k*(*disorder) + k_theta*dtheta, daikei);
        if((direction > 0 && *d_length <= 0) || (direction < 0 &&  *d_length >= 0)) {
            move(0, 0);
            break;
        }

    }

    wait(0.5);

    yellow = 0;
}


void back300()
{
    red = 1;

    float k = 0.9;
    int   k_theta = 2;

    int length, px, py, dx, dy;
    float daikei;

    update();

    px = coordinateX();
    py = coordinateY();

    length = 300;

    if(length == 0) return;

    turn_abs_rad(PI);

    while(1) {
        update();
        dx = coordinateX() - px;
        dy = coordinateY() - py;

        if(dy>max_disorder) {
            dy = max_disorder;
        } else if(dy<-max_disorder) {
            dy = -max_disorder;
        }


        move(-(30 + k*dy), -(32 - k*dy));


        if(dx>length) {
            move(0, 0);
            break;
        }

        //pc.printf("d_length:%d disorder:%d daikei:%f\n\r", *d_length, *disorder, daikei);
    }

    wait(0.5);

    red = 0;
}

float nearPi(float rad)
{
    float npi  = 0;
    
    while(1)
    {
        if(rad > npi + PI)
            npi += 2*PI;
        else if(rad < npi - PI)
            npi -= 2*PI;
        else
            return npi;
    }
}
